-- MariaDB dump 10.19  Distrib 10.9.8-MariaDB, for Win64 (AMD64)
--
-- Host: vm-db-accred-prerelease    Database: accreditation
-- ------------------------------------------------------
-- Server version	10.6.22-MariaDB-0ubuntu0.22.04.1

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

create database accreditation;
use accreditation;


--
-- Table structure for table `AspNetRoleClaims`
--

DROP TABLE IF EXISTS `AspNetRoleClaims`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `AspNetRoleClaims` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `RoleId` int(11) NOT NULL,
  `ClaimType` longtext DEFAULT NULL,
  `ClaimValue` longtext DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `IX_AspNetRoleClaims_RoleId` (`RoleId`),
  CONSTRAINT `FK_AspNetRoleClaims_AspNetRoles_RoleId` FOREIGN KEY (`RoleId`) REFERENCES `AspNetRoles` (`Id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AspNetRoleClaims`
--

LOCK TABLES `AspNetRoleClaims` WRITE;
/*!40000 ALTER TABLE `AspNetRoleClaims` DISABLE KEYS */;
/*!40000 ALTER TABLE `AspNetRoleClaims` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AspNetRoles`
--

DROP TABLE IF EXISTS `AspNetRoles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `AspNetRoles` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `Name` varchar(256) NOT NULL,
  `ConcurrencyStamp` longtext DEFAULT NULL,
  `NormalizedName` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`Id`),
  UNIQUE KEY `RoleNameIndex` (`NormalizedName`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AspNetRoles`
--

LOCK TABLES `AspNetRoles` WRITE;
/*!40000 ALTER TABLE `AspNetRoles` DISABLE KEYS */;
INSERT INTO `AspNetRoles` VALUES
(1,'Дирекция',NULL,NULL),
(2,'Подрядчик',NULL,NULL),
(3,'Управление сервиса',NULL,NULL),
(4,'Управление безопасности',NULL,NULL),
(5,'Управление печати и выдачи',NULL,NULL);
/*!40000 ALTER TABLE `AspNetRoles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AspNetUserClaims`
--

DROP TABLE IF EXISTS `AspNetUserClaims`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `AspNetUserClaims` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `UserId` int(11) NOT NULL,
  `ClaimType` longtext DEFAULT NULL,
  `ClaimValue` longtext DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `IX_AspNetUserClaims_UserId` (`UserId`),
  CONSTRAINT `FK_AspNetUserClaims_AspNetUsers_UserId` FOREIGN KEY (`UserId`) REFERENCES `AspNetUsers` (`Id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AspNetUserClaims`
--

LOCK TABLES `AspNetUserClaims` WRITE;
/*!40000 ALTER TABLE `AspNetUserClaims` DISABLE KEYS */;
/*!40000 ALTER TABLE `AspNetUserClaims` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AspNetUserLogins`
--

DROP TABLE IF EXISTS `AspNetUserLogins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `AspNetUserLogins` (
  `LoginProvider` varchar(255) NOT NULL,
  `ProviderKey` varchar(255) NOT NULL,
  `ProviderDisplayName` longtext DEFAULT NULL,
  `UserId` int(11) NOT NULL,
  PRIMARY KEY (`LoginProvider`,`ProviderKey`),
  KEY `IX_AspNetUserLogins_UserId` (`UserId`),
  CONSTRAINT `FK_AspNetUserLogins_AspNetUsers_UserId` FOREIGN KEY (`UserId`) REFERENCES `AspNetUsers` (`Id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AspNetUserLogins`
--

LOCK TABLES `AspNetUserLogins` WRITE;
/*!40000 ALTER TABLE `AspNetUserLogins` DISABLE KEYS */;
/*!40000 ALTER TABLE `AspNetUserLogins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AspNetUserRoles`
--

DROP TABLE IF EXISTS `AspNetUserRoles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `AspNetUserRoles` (
  `UserId` int(11) NOT NULL,
  `RoleId` int(11) NOT NULL,
  PRIMARY KEY (`UserId`,`RoleId`),
  KEY `IX_AspNetUserRoles_RoleId` (`RoleId`),
  CONSTRAINT `FK_AspNetUserRoles_AspNetRoles_RoleId` FOREIGN KEY (`RoleId`) REFERENCES `AspNetRoles` (`Id`) ON DELETE CASCADE,
  CONSTRAINT `FK_AspNetUserRoles_AspNetUsers_UserId` FOREIGN KEY (`UserId`) REFERENCES `AspNetUsers` (`Id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AspNetUserRoles`
--

LOCK TABLES `AspNetUserRoles` WRITE;
/*!40000 ALTER TABLE `AspNetUserRoles` DISABLE KEYS */;
/*!40000 ALTER TABLE `AspNetUserRoles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AspNetUserTokens`
--

DROP TABLE IF EXISTS `AspNetUserTokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `AspNetUserTokens` (
  `UserId` int(11) NOT NULL,
  `LoginProvider` varchar(255) NOT NULL,
  `Name` varchar(255) NOT NULL,
  `Value` longtext DEFAULT NULL,
  PRIMARY KEY (`UserId`,`LoginProvider`,`Name`),
  CONSTRAINT `FK_AspNetUserTokens_AspNetUsers_UserId` FOREIGN KEY (`UserId`) REFERENCES `AspNetUsers` (`Id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `AspNetUsers`
--

DROP TABLE IF EXISTS `AspNetUsers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `AspNetUsers` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `Name` longtext NOT NULL,
  `Email` varchar(256) DEFAULT NULL,
  `RoleId` int(11) DEFAULT NULL,
  `FullName` longtext NOT NULL,
  `AgreementFile` longtext NOT NULL,
  `CardFile` longtext NOT NULL,
  `Comment` longtext NOT NULL,
  `AccessFailedCount` int(11) NOT NULL DEFAULT 0,
  `ConcurrencyStamp` longtext DEFAULT NULL,
  `EmailConfirmed` tinyint(1) NOT NULL DEFAULT 0,
  `LockoutEnabled` tinyint(1) NOT NULL DEFAULT 0,
  `LockoutEnd` datetime(6) DEFAULT NULL,
  `NormalizedEmail` varchar(256) DEFAULT NULL,
  `NormalizedUserName` varchar(256) DEFAULT NULL,
  `PasswordHash` longtext DEFAULT NULL,
  `PhoneNumber` longtext DEFAULT NULL,
  `PhoneNumberConfirmed` tinyint(1) NOT NULL DEFAULT 0,
  `SecurityStamp` longtext DEFAULT NULL,
  `TwoFactorEnabled` tinyint(1) NOT NULL DEFAULT 0,
  `UserName` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`Id`),
  UNIQUE KEY `UserNameIndex` (`NormalizedUserName`),
  KEY `IX_AspNetUsers_RoleId` (`RoleId`),
  KEY `EmailIndex` (`NormalizedEmail`),
  CONSTRAINT `FK_AspNetUsers_AspNetRoles_RoleId` FOREIGN KEY (`RoleId`) REFERENCES `AspNetRoles` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AspNetUsers`
--

LOCK TABLES `AspNetUsers` WRITE;
/*!40000 ALTER TABLE `AspNetUsers` DISABLE KEYS */;
INSERT INTO `AspNetUsers` VALUES
(2,'Админ','admin@admin.admin',1,'asdas','','','aa',0,'df8e9117-3b0f-49af-ac16-5416052032f1',1,1,NULL,'ADMIN@ADMIN.ADMIN','ADMIN@ADMIN.ADMIN','AQAAAAIAAYagAAAAEJs3h/64CDeGYeyf1Kot8aAzrqm2Yq1iqLUc8vbzqVLiGFRA+sXvmpokAZRXrYlrxA==','71231231231',0,'Y6BCZVP2LMOS6WZ4F7UFAFWRZZG6JUGO',0,'admin@admin.admin'),
(3,'Михаил','test@test.r',1,'','','','',0,NULL,0,0,NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL),
(4,'Анжелика','anzhelika_v@holdingbp.ru',1,'','','','',0,NULL,0,0,NULL,NULL,NULL,NULL,NULL,0,NULL,0,NULL),
(5,'Сергей','sergey_b@autobus1.com',1,'Сергей','','','',0,'c8e233e8-e9ad-4d20-8c63-bce41feb6e8f',1,1,NULL,'SERGEY_B@AUTOBUS1.COM','SERGEY_B@AUTOBUS1.COM','AQAAAAIAAYagAAAAEIwGzZmdW1RtgQv+5eZCV4Cf4q+6XPQnmrffevwZ/eb0iAvVEClkgAyQ4I4TEda7gw==','',0,'L5YF55PGFC2UN3LKCQZOIEJRIBWFKXCF',0,'sergey_b@autobus1.com');
/*!40000 ALTER TABLE `AspNetUsers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `AuditHistories`
--

DROP TABLE IF EXISTS `AuditHistories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `AuditHistories` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `CreatedOn` datetime(6) NOT NULL DEFAULT utc_timestamp(),
  `CreatedById` int(11) DEFAULT NULL,
  `EntityType` int(11) NOT NULL,
  `EntityId` int(11) NOT NULL,
  `EntityField` longtext NOT NULL,
  `Value` longtext NOT NULL,
  PRIMARY KEY (`Id`),
  KEY `IX_AuditHistories_CreatedById` (`CreatedById`),
  CONSTRAINT `FK_AuditHistories_AspNetUsers_CreatedById` FOREIGN KEY (`CreatedById`) REFERENCES `AspNetUsers` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `AuditHistories`
--

LOCK TABLES `AuditHistories` WRITE;
/*!40000 ALTER TABLE `AuditHistories` DISABLE KEYS */;
INSERT INTO `AuditHistories` VALUES
(1,'2025-10-31 05:56:29.000000',5,0,11,'StatusId','Черновик');
/*!40000 ALTER TABLE `AuditHistories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Commentaries`
--

DROP TABLE IF EXISTS `Commentaries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Commentaries` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `Text` longtext NOT NULL,
  `CreatedOn` datetime(6) NOT NULL DEFAULT utc_timestamp(),
  `CreatedById` int(11) DEFAULT NULL,
  `TechTicketId` int(11) DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `IX_Commentaries_CreatedById` (`CreatedById`),
  KEY `IX_Commentaries_TechTicketId` (`TechTicketId`),
  CONSTRAINT `FK_Commentaries_AspNetUsers_CreatedById` FOREIGN KEY (`CreatedById`) REFERENCES `AspNetUsers` (`Id`),
  CONSTRAINT `FK_Commentaries_TechTickets_TechTicketId` FOREIGN KEY (`TechTicketId`) REFERENCES `TechTickets` (`Id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Commentaries`
--

LOCK TABLES `Commentaries` WRITE;
/*!40000 ALTER TABLE `Commentaries` DISABLE KEYS */;
/*!40000 ALTER TABLE `Commentaries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `EmailLogs`
--

DROP TABLE IF EXISTS `EmailLogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `EmailLogs` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `Theme` longtext NOT NULL,
  `Text` longtext NOT NULL,
  `Email` longtext NOT NULL,
  `CreatedOn` datetime(6) NOT NULL DEFAULT utc_timestamp(),
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `EmailLogs`
--

LOCK TABLES `EmailLogs` WRITE;
/*!40000 ALTER TABLE `EmailLogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `EmailLogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `HtmlColors`
--

DROP TABLE IF EXISTS `HtmlColors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `HtmlColors` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `Name` longtext NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `HtmlColors`
--

LOCK TABLES `HtmlColors` WRITE;
/*!40000 ALTER TABLE `HtmlColors` DISABLE KEYS */;
INSERT INTO `HtmlColors` VALUES
(6,'Белый'),
(7,'Бежевый'),
(8,'Голубой'),
(9,'Желтый'),
(10,'Зеленый'),
(11,'Красный'),
(12,'Оранжевый'),
(13,'Розовый'),
(14,'Серый'),
(15,'Синий'),
(16,'Пурпурный'),
(17,'Бордовый'),
(18,'Градиентный'),
(19,'Золотистый'),
(20,'Коричневый'),
(21,'Разноцветный'),
(22,'Салатовый'),
(23,'Серебристый'),
(24,'Сиреневый'),
(25,'Темно-синий'),
(26,'Фиолетовый'),
(27,'Хаки'),
(28,'Черный'),
(29,'Темно зеленый'),
(30,'Мята'),
(41,'Лазурный'),
(42,'Бирюзовый'),
(44,'Лаймовый'),
(50,'Серо-голубой'),
(52,'Серый-Черный'),
(53,'Многоцветный'),
(54,'Темно-бордовый'),
(55,'Темно-Серый'),
(56,'Черно-красный'),
(57,'Темно-синий металлик'),
(58,'Снежно-Белый перламутр'),
(59,'Черный металлик'),
(60,'Белый перламутр'),
(61,'Серый темно-серый'),
(62,'Белый металлик');
/*!40000 ALTER TABLE `HtmlColors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Quotas`
--

DROP TABLE IF EXISTS `Quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Quotas` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `InitiatorId` int(11) DEFAULT NULL,
  `TypePassId` int(11) DEFAULT NULL,
  `CountTransports` int(11) NOT NULL,
  `UsedCountTransports` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`Id`),
  KEY `IX_Quotas_InitiatorId` (`InitiatorId`),
  KEY `IX_Quotas_TypePassId` (`TypePassId`),
  CONSTRAINT `FK_Quotas_AspNetUsers_InitiatorId` FOREIGN KEY (`InitiatorId`) REFERENCES `AspNetUsers` (`Id`),
  CONSTRAINT `FK_Quotas_TypePasses_TypePassId` FOREIGN KEY (`TypePassId`) REFERENCES `TypePasses` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Quotas`
--

LOCK TABLES `Quotas` WRITE;
/*!40000 ALTER TABLE `Quotas` DISABLE KEYS */;
INSERT INTO `Quotas` VALUES
(1,2,1,100,0);
/*!40000 ALTER TABLE `Quotas` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Requests`
--

DROP TABLE IF EXISTS `Requests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Requests` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `InitiatorId` int(11) DEFAULT NULL,
  `CreatedOn` datetime(6) NOT NULL DEFAULT utc_timestamp(),
  `StatusId` int(11) DEFAULT NULL,
  `ResponsibleManagementServiceId` int(11) DEFAULT NULL,
  `ResponsibleSecurityManagementId` int(11) DEFAULT NULL,
  `ResponsibleForPrintingId` int(11) DEFAULT NULL,
  `SecurityStatusId` int(11) DEFAULT NULL,
  `Comment` longtext DEFAULT NULL,
  `Version` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  PRIMARY KEY (`Id`),
  KEY `IX_Requests_InitiatorId` (`InitiatorId`),
  KEY `IX_Requests_ResponsibleForPrintingId` (`ResponsibleForPrintingId`),
  KEY `IX_Requests_ResponsibleManagementServiceId` (`ResponsibleManagementServiceId`),
  KEY `IX_Requests_ResponsibleSecurityManagementId` (`ResponsibleSecurityManagementId`),
  KEY `IX_Requests_StatusId` (`StatusId`),
  KEY `IX_Requests_SecurityStatusId` (`SecurityStatusId`),
  CONSTRAINT `FK_Requests_AspNetUsers_InitiatorId` FOREIGN KEY (`InitiatorId`) REFERENCES `AspNetUsers` (`Id`),
  CONSTRAINT `FK_Requests_AspNetUsers_ResponsibleForPrintingId` FOREIGN KEY (`ResponsibleForPrintingId`) REFERENCES `AspNetUsers` (`Id`),
  CONSTRAINT `FK_Requests_AspNetUsers_ResponsibleManagementServiceId` FOREIGN KEY (`ResponsibleManagementServiceId`) REFERENCES `AspNetUsers` (`Id`),
  CONSTRAINT `FK_Requests_AspNetUsers_ResponsibleSecurityManagementId` FOREIGN KEY (`ResponsibleSecurityManagementId`) REFERENCES `AspNetUsers` (`Id`),
  CONSTRAINT `FK_Requests_SecurityStatuses_SecurityStatusId` FOREIGN KEY (`SecurityStatusId`) REFERENCES `SecurityStatuses` (`Id`),
  CONSTRAINT `FK_Requests_Statuses_StatusId` FOREIGN KEY (`StatusId`) REFERENCES `Statuses` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Requests`
--

LOCK TABLES `Requests` WRITE;
/*!40000 ALTER TABLE `Requests` DISABLE KEYS */;
INSERT INTO `Requests` VALUES
(9,4,'2024-05-13 09:51:25.000000',5,3,3,3,NULL,NULL,'2025-10-30 09:53:41.310394'),
(11,5,'2025-10-31 05:56:29.000000',1,NULL,NULL,NULL,NULL,NULL,'2025-10-31 05:56:29.802385');
/*!40000 ALTER TABLE `Requests` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`accreditation_user`@`10.100.100.149`*/ /*!50003 trigger Requests_AuditHistory_Trigger after insert on Requests
for each row 
begin
   	declare status_name varchar(255);
   	set status_name = (select Statuses.`Name` from Statuses where new.StatusId = Statuses.Id);
		if new.StatusId is not null
		then insert into AuditHistories(CreatedOn, CreatedById, EntityType, EntityId, EntityField, `Value`) values (new.CreatedOn, new.InitiatorId, 0, new.Id, 'StatusId', status_name);
		end if;
end */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `SecurityStatuses`
--

DROP TABLE IF EXISTS `SecurityStatuses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SecurityStatuses` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `Name` longtext NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SecurityStatuses`
--

LOCK TABLES `SecurityStatuses` WRITE;
/*!40000 ALTER TABLE `SecurityStatuses` DISABLE KEYS */;
INSERT INTO `SecurityStatuses` VALUES
(1,'Новый');
/*!40000 ALTER TABLE `SecurityStatuses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Statuses`
--

DROP TABLE IF EXISTS `Statuses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Statuses` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `Name` longtext NOT NULL,
  `Index` int(11) NOT NULL DEFAULT 0,
  `Positive` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Statuses`
--

LOCK TABLES `Statuses` WRITE;
/*!40000 ALTER TABLE `Statuses` DISABLE KEYS */;
INSERT INTO `Statuses` VALUES
(1,'Черновик',1,1),
(2,'Отклонена',2,1),
(3,'Частично отклонена',3,1),
(4,'На согласовании с департаментом транспорта',4,1),
(5,'На согласовании с департаментом безопасности',5,1),
(6,'Отправлена на печать',6,1),
(7,'Удалена',7,1),
(8,'Напечатана',8,1),
(9,'Выдана',9,1),
(10,'Отказ СБ',10,1),
(11,'На проверке в СБ',11,1);
/*!40000 ALTER TABLE `Statuses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Subjects`
--

DROP TABLE IF EXISTS `Subjects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Subjects` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `Name` longtext NOT NULL,
  `FullName` longtext NOT NULL,
  `Address` longtext NOT NULL,
  `ContactPerson` longtext NOT NULL,
  `ContactData` longtext NOT NULL,
  `Code` longtext NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Subjects`
--

LOCK TABLES `Subjects` WRITE;
/*!40000 ALTER TABLE `Subjects` DISABLE KEYS */;
INSERT INTO `Subjects` VALUES
(2,'Expo центр','Экспо центр Казань','улица Выставочная, здание 1, корпус 1, подъезд 1','Кирилл','+79999999999','EXP');
/*!40000 ALTER TABLE `Subjects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `TechTickets`
--

DROP TABLE IF EXISTS `TechTickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `TechTickets` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `Theme` longtext NOT NULL,
  `Text` longtext NOT NULL,
  `Status` int(11) NOT NULL DEFAULT 0,
  `CreatedOn` datetime(6) NOT NULL DEFAULT utc_timestamp(),
  `CreatedById` int(11) DEFAULT NULL,
  `ResponsibleId` int(11) DEFAULT NULL,
  `Version` timestamp(6) NOT NULL DEFAULT current_timestamp(6) ON UPDATE current_timestamp(6),
  PRIMARY KEY (`Id`),
  KEY `IX_TechTickets_CreatedById` (`CreatedById`),
  KEY `IX_TechTickets_ResponsibleId` (`ResponsibleId`),
  CONSTRAINT `FK_TechTickets_AspNetUsers_CreatedById` FOREIGN KEY (`CreatedById`) REFERENCES `AspNetUsers` (`Id`),
  CONSTRAINT `FK_TechTickets_AspNetUsers_ResponsibleId` FOREIGN KEY (`ResponsibleId`) REFERENCES `AspNetUsers` (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `TechTickets`
--

LOCK TABLES `TechTickets` WRITE;
/*!40000 ALTER TABLE `TechTickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `TechTickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `TransportManufacturers`
--

DROP TABLE IF EXISTS `TransportManufacturers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `TransportManufacturers` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `Name` longtext NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=310 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `TransportManufacturers`
--

LOCK TABLES `TransportManufacturers` WRITE;
/*!40000 ALTER TABLE `TransportManufacturers` DISABLE KEYS */;
INSERT INTO `TransportManufacturers` VALUES
(1,'MAN'),
(2,'Volvo'),
(3,'Neoplan'),
(4,'Lexus'),
(5,'Toyota'),
(6,'Peugeot'),
(7,'ГАЗ'),
(8,'ПАЗ'),
(9,'Isuzu'),
(10,'КАВЗ'),
(11,'Higer'),
(12,'KIA'),
(13,'Yutong'),
(14,'Mercedes'),
(15,'Ford'),
(16,'FIAT'),
(18,'Scania'),
(19,'Daewoo'),
(20,'Икарус'),
(21,'Mudan'),
(24,'King Long'),
(25,'Setra'),
(27,'Golden Dragon'),
(28,'Volkswagen'),
(29,'Citroen'),
(30,'Chevrolet'),
(32,'Van Hool'),
(33,'Temsa'),
(34,'ЛиАЗ'),
(35,'Нефаз'),
(36,'SsangYong'),
(37,'Mitsubishi'),
(39,'Chrysler'),
(40,'Infiniti'),
(41,'Hummer'),
(42,'Lada'),
(44,'Cadillac'),
(45,'Jaguar'),
(46,'Porsche'),
(47,'Волга'),
(48,'Hyundai'),
(49,'Freightliner'),
(50,'Navistar International'),
(51,'Renault'),
(52,'DAF'),
(53,'BMW'),
(54,'Opel'),
(55,'Audi'),
(56,'Bentley'),
(57,'Nissan'),
(58,'Skoda'),
(59,'Land Rover'),
(60,'МАЗ'),
(61,'КамАЗ'),
(62,'Голаз'),
(63,'BAW'),
(64,'Acura'),
(65,'Alfa Romeo'),
(66,'Alpina'),
(67,'Aston Martin'),
(68,'BYD'),
(69,'Brilliance'),
(70,'Changan'),
(71,'Chery'),
(72,'Datsun'),
(73,'Dodge'),
(74,'FAW'),
(75,'Ferrari'),
(76,'Geely'),
(77,'Great Wall'),
(78,'Haval'),
(79,'Honda'),
(80,'Jeep'),
(81,'Lamborghini'),
(82,'LIFAN'),
(83,'Lotus'),
(84,'Maserati'),
(85,'Mazda'),
(86,'MINI'),
(87,'Rolls-Royce'),
(88,'SEAT'),
(89,'Subaru'),
(90,'Suzuki'),
(92,'ZAZ'),
(93,'ТагАЗ'),
(94,'УАЗ'),
(95,'Luxgen'),
(96,'Smart'),
(97,'Богдан'),
(98,'Sanlong'),
(99,'Zhong Tong'),
(101,'Lincoln'),
(102,'Iveco'),
(103,'Otoyol'),
(105,'Bova'),
(106,'Лаз'),
(107,'Волжанин'),
(108,'Autosan'),
(112,'JAC'),
(113,'LAG'),
(114,'ShenLong'),
(115,'Tata Marcopolo'),
(116,'Zonda'),
(117,'Неман'),
(118,'РАФ'),
(119,'Noge'),
(120,'LDV Group Limited'),
(121,'ВИС'),
(123,'МАРЗ'),
(124,'Bomag '),
(125,'Caterpilar'),
(126,'Dong Feng'),
(128,'JCB '),
(134,'Schmitz '),
(135,'TATRA '),
(136,'Terex '),
(137,'XCMG '),
(138,'Амкодор '),
(139,'БЕЛАЗ '),
(140,'ЗИЛ '),
(141,'КРАЗ '),
(142,'Кировец '),
(143,'МЗКТ'),
(144,'Четра'),
(145,'ЧМЗ'),
(146,'Bobcat'),
(147,'Doosan '),
(149,'Hitachi'),
(151,'HOWO '),
(153,'Komatsu '),
(154,'Lonking '),
(155,'MST '),
(157,'Sany '),
(158,'Tadano '),
(159,'Tata Hitachi '),
(160,'XGMA '),
(161,'МТЗ '),
(162,'Мотовилиха '),
(163,'САМС '),
(164,'ЧТЗ-Уралтрак '),
(165,'Airman '),
(166,'Ammann '),
(167,'CAMC '),
(168,'CASE '),
(170,'John Deere '),
(172,'Kawasaki '),
(173,'Liebherr '),
(174,'Merlo '),
(175,'New Holland '),
(177,'Samsung '),
(178,'Zoomlion '),
(179,'Тонар'),
(180,'Shantui'),
(181,'Урал'),
(182,'Hino'),
(183,'Раскат'),
(184,'ТВЭКС'),
(185,'МОАЗ'),
(186,'УВЗ'),
(187,'HSW'),
(188,'МКСМ'),
(193,'Татра'),
(194,'Daimler AG'),
(196,'Shuchi'),
(197,'GMC'),
(198,'Solaris'),
(199,'Marcopolo'),
(200,'EOS'),
(201,'ТАМ'),
(202,'Тата'),
(203,'Альтерна'),
(204,'БАЗ'),
(205,'ВМЗ'),
(206,'Кубань'),
(207,'РоАЗ'),
(208,'Родник'),
(209,'САРЗ'),
(210,'YouYi'),
(211,'Yaxing'),
(212,'Youngman'),
(213,'Volgabus'),
(214,'Кузбасс'),
(215,'СканТат'),
(216,'Aabenraa'),
(217,'Ajokki'),
(218,'Foton'),
(219,'Anadolu'),
(220,'Andecar'),
(221,'Asia'),
(222,'Automet'),
(224,'Ayats'),
(225,'Barbi'),
(226,'Berkhof'),
(227,'Beulas'),
(229,'Blue Bird'),
(230,'Burillo'),
(231,'Cacciamali'),
(232,'Caetano'),
(234,'Avtomontaza'),
(235,'Camo'),
(236,'Carrus'),
(237,'Carvin'),
(238,'Cobus'),
(239,'DAB'),
(240,'De Simon'),
(241,'Delta'),
(242,'Den Oudsten'),
(243,'Drogmoller'),
(244,'ECW'),
(245,'EA KFB'),
(246,'Ernst Auwarter'),
(247,'Gangloff'),
(250,'Graf & Stift'),
(251,'Guleryuz'),
(252,'Haargaz'),
(254,'Hispano'),
(255,'Huang Hai'),
(256,'Huaxia'),
(257,'Ikarbus'),
(258,'Indcar '),
(259,'Irisbus'),
(260,'Irizar'),
(261,'Jelcz'),
(262,'Jonckheere'),
(263,'Karosa'),
(264,'Kravtex'),
(265,'Kutter'),
(266,'Lahti'),
(267,'Lauber'),
(268,'Magirus-Deutz'),
(269,'Marbus'),
(270,'Menarini'),
(271,'Obradors'),
(272,'Orlandi'),
(273,'Otokar'),
(274,'Park Royal'),
(276,'Sanos'),
(277,'Saffle'),
(278,'Shaolin'),
(279,'SOR'),
(280,'Steyr'),
(281,'SunLong'),
(282,'Sunsundegui'),
(284,'Thomas'),
(285,'Tomassini'),
(286,'Vest'),
(287,'Vetter'),
(288,'Viseon'),
(289,'Wiima'),
(291,'Ugarte'),
(292,'Unicar '),
(294,'TAZ'),
(295,'VBK'),
(296,'AdMirall'),
(297,'Krystal'),
(298,'Goppel'),
(300,'Trafora'),
(301,'Barkas-Werke'),
(302,'Comil'),
(303,'Maxibus'),
(304,'Volare'),
(305,'Ankai'),
(308,'Hongqi'),
(309,'Genesis');
/*!40000 ALTER TABLE `TransportManufacturers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `TransportModels`
--

DROP TABLE IF EXISTS `TransportModels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `TransportModels` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `Name` longtext NOT NULL,
  `TransportManufacturerId` int(11) DEFAULT NULL,
  `Type` int(11) DEFAULT NULL,
  `Class` int(11) DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `IX_TransportModels_TransportManufacturerId` (`TransportManufacturerId`),
  CONSTRAINT `FK_TransportModels_TransportManufacturers_TransportManufacturer~` FOREIGN KEY (`TransportManufacturerId`) REFERENCES `TransportManufacturers` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=3334 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `TransportModels`
--

LOCK TABLES `TransportModels` WRITE;
/*!40000 ALTER TABLE `TransportModels` DISABLE KEYS */;
INSERT INTO `TransportModels` VALUES
(850,'Исузу',97,NULL,NULL),
(851,'32054',8,NULL,NULL),
(852,'Rosa',37,NULL,NULL),
(853,'Aero Town',48,NULL,NULL),
(854,'Asia Cosmos',12,NULL,NULL),
(855,'3203',8,NULL,NULL),
(856,'695',106,NULL,NULL),
(857,'250-256',20,NULL,NULL),
(858,'6885',11,NULL,NULL),
(859,'Granbird',12,NULL,NULL),
(860,'BX 212',19,NULL,NULL),
(861,'5256',34,NULL,NULL),
(862,'Apollo',21,NULL,NULL),
(863,'6129',13,NULL,NULL),
(864,'Scania',18,NULL,NULL),
(865,'Aerospace',48,NULL,NULL),
(866,'O303',14,NULL,NULL),
(867,'A13 S2000',1,NULL,NULL),
(868,'O350 Tourismo',14,NULL,NULL),
(869,'Neoplan',3,NULL,NULL),
(870,'B8',2,NULL,NULL),
(871,'B12',2,NULL,NULL),
(872,'Carus',2,NULL,NULL),
(873,'B10 Van Hool',2,NULL,NULL),
(874,'Travego',14,NULL,NULL),
(876,'O404',14,NULL,NULL),
(877,'815',32,NULL,NULL),
(878,'Неоплан (Со столами)',3,NULL,NULL),
(880,'O403',14,NULL,NULL),
(881,'6896',27,NULL,NULL),
(882,'Prestij',37,NULL,NULL),
(883,'R07 Lion\'s Coach',1,NULL,NULL),
(884,'315',25,NULL,NULL),
(885,'XMQ6130',24,NULL,NULL),
(886,'212',25,NULL,NULL),
(887,'Universe',48,NULL,NULL),
(888,'Intouro',14,NULL,NULL),
(890,'Maz-Man',1,NULL,NULL),
(891,'HyperAero',36,NULL,NULL),
(892,'Safari',33,NULL,NULL),
(893,'215',25,NULL,NULL),
(894,'Aero City',48,NULL,NULL),
(895,'Хюндай',97,NULL,NULL),
(896,'6831 Городской',13,NULL,NULL),
(898,'Setra',25,NULL,NULL),
(899,'Лайнер',106,NULL,NULL),
(900,'O302',14,NULL,NULL),
(901,'R07L Lion\'s Coach',1,NULL,NULL),
(903,'6129',11,NULL,NULL),
(904,'Tourliner',3,NULL,NULL),
(905,'O307',14,NULL,NULL),
(907,'Viano',14,NULL,NULL),
(908,'Multivan',28,NULL,NULL),
(909,'Vito',14,NULL,NULL),
(910,'Starex H-1',48,NULL,NULL),
(911,'Boxer Mini',6,NULL,NULL),
(912,'Hiace',5,NULL,NULL),
(913,'Express',30,NULL,NULL),
(914,'Sharan',28,NULL,NULL),
(916,'Alphard',5,NULL,NULL),
(917,'Trafic',51,NULL,NULL),
(918,'Serena',57,NULL,NULL),
(919,'Tourneo',15,NULL,NULL),
(920,'Zafira',54,NULL,NULL),
(922,'Ducato 3',16,NULL,NULL),
(923,'Transit',15,NULL,NULL),
(924,'Sprinter',14,NULL,NULL),
(925,'Istana',14,NULL,NULL),
(926,'Daily',102,NULL,NULL),
(927,'Boxer',6,NULL,NULL),
(928,'Coaster',5,NULL,NULL),
(929,'County',48,NULL,NULL),
(930,'Газель',7,NULL,NULL),
(931,'Jumper',29,NULL,NULL),
(934,'Crafter',28,NULL,NULL),
(935,'Sprinter Lux',14,NULL,NULL),
(937,'122 Skyliner',3,NULL,NULL),
(938,'TDЕ *** Astromega',32,NULL,NULL),
(939,'Gregal',119,NULL,NULL),
(940,'128 Megaliner',3,NULL,NULL),
(996,'MDX (III поколение)',64,NULL,NULL),
(997,'RDX (II поколение)',64,NULL,NULL),
(998,'159 (I поколение)',65,NULL,NULL),
(999,'4C (I поколение)',65,NULL,NULL),
(1000,'Giulietta (III поколение)',65,NULL,NULL),
(1001,'MiTo (I поколение)',65,NULL,NULL),
(1002,'B3 (F30/F31)',66,NULL,NULL),
(1003,'B5 (E60/E61)',66,NULL,NULL),
(1004,'B5 (F10/F11)',66,NULL,NULL),
(1005,'B6 (E63/E64)',66,NULL,NULL),
(1006,'B6 (F12/F13)',66,NULL,NULL),
(1007,'B7 (F01/F02)',66,NULL,NULL),
(1008,'B7 (F01/F02 рестайлинг)',66,NULL,NULL),
(1009,'D5 (F10/F11)',66,NULL,NULL),
(1010,'DB9 (I поколение 2-ой рестайлинг)',67,NULL,NULL),
(1011,'DB9 (I поколение рестайлинг)',67,NULL,NULL),
(1012,'DBS (I поколение)',67,NULL,NULL),
(1013,'Rapide (I поколение)',67,NULL,NULL),
(1014,'Rapide (I поколение рестайлинг)',67,NULL,NULL),
(1015,'V12 Vantage (I поколение)',67,NULL,NULL),
(1016,'V8 Vantage (III поколение 2-й рестайлинг)',67,NULL,NULL),
(1017,'Vanquish (II поколение)',67,NULL,NULL),
(1018,'Virage (I поколение)',67,NULL,NULL),
(1019,'A1 (I поколение)',55,NULL,NULL),
(1020,'A3 (8P/8PA 2-й рестайлинг)',55,NULL,NULL),
(1021,'A3 (8V)',55,NULL,NULL),
(1022,'A4 (B8)',55,NULL,NULL),
(1023,'A4 (B8 рестайлинг)',55,NULL,NULL),
(1024,'A5 (I поколение)',55,NULL,NULL),
(1025,'A5 (I поколение рестайлинг)',55,NULL,NULL),
(1026,'A6 (C6 рестайлинг)',55,NULL,NULL),
(1027,'A6',55,NULL,NULL),
(1028,'A7 (I поколение)',55,NULL,NULL),
(1029,'A7 (I поколение рестайлинг)',55,NULL,NULL),
(1030,'A8 (D3 рестайлинг)',55,NULL,NULL),
(1031,'A8 (D4)',55,NULL,NULL),
(1032,'A8 (D4 рестайлинг)',55,NULL,NULL),
(1033,'Q3 (I поколение)',55,NULL,NULL),
(1034,'Q5 (I поколение)',55,NULL,NULL),
(1035,'Q5 (I поколение рестайлинг)',55,NULL,NULL),
(1036,'Q7 (I поколение)',55,NULL,NULL),
(1037,'R8 (I поколение)',55,NULL,NULL),
(1038,'R8 (I поколение рестайлинг)',55,NULL,NULL),
(1039,'RS3 (8PA)',55,NULL,NULL),
(1040,'RS4 (B8 рестайлинг)',55,NULL,NULL),
(1041,'RS5 (I поколение)',55,NULL,NULL),
(1042,'RS5 (I поколение рестайлинг)',55,NULL,NULL),
(1043,'RS6 (C6 рестайлинг)',55,NULL,NULL),
(1044,'RS6 (C7)',55,NULL,NULL),
(1045,'RS7 (I поколение)',55,NULL,NULL),
(1046,'RS Q3 (I поколение)',55,NULL,NULL),
(1047,'S3 (8P/8PA рестайлинг)',55,NULL,NULL),
(1048,'S3 (8V)',55,NULL,NULL),
(1049,'S4 (B8)',55,NULL,NULL),
(1050,'S4 (B8 рестайлинг)',55,NULL,NULL),
(1051,'S5 (I поколение)',55,NULL,NULL),
(1052,'S5 (I поколение рестайлинг)',55,NULL,NULL),
(1053,'S6 (C6 рестайлинг)',55,NULL,NULL),
(1054,'S6 (C7)',55,NULL,NULL),
(1055,'S7 (I поколение)',55,NULL,NULL),
(1056,'S7 (I поколение рестайлинг)',55,NULL,NULL),
(1057,'S8 (D4)',55,NULL,NULL),
(1058,'SQ5 (I поколение рестайлинг)',55,NULL,NULL),
(1059,'TT (8J)',55,NULL,NULL),
(1060,'TT (8S)',55,NULL,NULL),
(1061,'TT RS (8J)',55,NULL,NULL),
(1062,'TTS (8J)',55,NULL,NULL),
(1063,'Arnage (I поколение рестайлинг)',56,NULL,NULL),
(1064,'Azure (II поколение)',56,NULL,NULL),
(1065,'Brooklands (II поколение)',56,NULL,NULL),
(1066,'Continental Flying Spur (III поколение)',56,NULL,NULL),
(1067,'Continental Flying Spur (IV поколение)',56,NULL,NULL),
(1068,'Continental GT (I поколение)',56,NULL,NULL),
(1069,'Continental GT (II поколение)',56,NULL,NULL),
(1070,'Continental GTC (I поколение)',56,NULL,NULL),
(1071,'Continental GTC (II поколение)',56,NULL,NULL),
(1072,'Mulsanne (II поколение)',56,NULL,NULL),
(1073,'1 серия (E81/E82/E87/E88 рестайлинг)',53,NULL,NULL),
(1074,'1 серия (F20/F21)',53,NULL,NULL),
(1075,'1 серия M (E81/E82/E87/E88)',53,NULL,NULL),
(1076,'2 серия (F22/F23)',53,NULL,NULL),
(1077,'2 серия Active Tourer (F45)',53,NULL,NULL),
(1078,'3 серия (E90/E91/E92/E93 рестайлинг)',53,NULL,NULL),
(1079,'3 серия (F30/F31)',53,NULL,NULL),
(1080,'3 серия Гран Туризмо (F34)',53,NULL,NULL),
(1081,'4 серия (F32/F33/F36)',53,NULL,NULL),
(1082,'5',53,NULL,NULL),
(1083,'5 серия (F10/F11 рестайлинг)',53,NULL,NULL),
(1084,'5 серия Гран Туризмо (F07)',53,NULL,NULL),
(1085,'5 серия Гран Туризмо (F07 рестайлинг)',53,NULL,NULL),
(1086,'6 серия (E63/E64)',53,NULL,NULL),
(1087,'6 серия (F06/F12/F13)',53,NULL,NULL),
(1088,'7',53,NULL,NULL),
(1089,'7 серия (F01/F02 рестайлинг)',53,NULL,NULL),
(1090,'i3 (I поколение)',53,NULL,NULL),
(1091,'i8 (I поколение)',53,NULL,NULL),
(1092,'M3 (E90/E91/E92/E93)',53,NULL,NULL),
(1093,'M3 (F30)',53,NULL,NULL),
(1094,'M4 (F32/F33)',53,NULL,NULL),
(1095,'M5 (F10/F11)',53,NULL,NULL),
(1096,'M5 (F10/F11 рестайлинг)',53,NULL,NULL),
(1097,'M6 (E63/E64)',53,NULL,NULL),
(1098,'M6 (F06/F12/F13)',53,NULL,NULL),
(1099,'X1 (E84)',53,NULL,NULL),
(1100,'X1 (E84 рестайлинг)',53,NULL,NULL),
(1101,'X3 (E83 рестайлинг)',53,NULL,NULL),
(1102,'X3 (F25)',53,NULL,NULL),
(1103,'X3 (F25 рестайлинг)',53,NULL,NULL),
(1104,'X4 (F26)',53,NULL,NULL),
(1105,'X5 (E70)',53,NULL,NULL),
(1106,'X5 (E70 рестайлинг)',53,NULL,NULL),
(1107,'X5 (F15)',53,NULL,NULL),
(1108,'X5 M (E70)',53,NULL,NULL),
(1109,'X6 (E71)',53,NULL,NULL),
(1110,'X6 (E71 рестайлинг)',53,NULL,NULL),
(1111,'X6 (F16)',53,NULL,NULL),
(1112,'X6 M (E71)',53,NULL,NULL),
(1113,'Z4 (E89)',53,NULL,NULL),
(1114,'H530 (I поколение)',69,NULL,NULL),
(1115,'F0 (I поколение)',68,NULL,NULL),
(1116,'F3 (I поколение)',68,NULL,NULL),
(1117,'F3-R (I поколение)',68,NULL,NULL),
(1118,'ATS (I поколение)',44,NULL,NULL),
(1119,'BLS (I поколение)',44,NULL,NULL),
(1120,'CTS (II поколение)',44,NULL,NULL),
(1121,'CTS (III поколение)',44,NULL,NULL),
(1122,'CTS-V (II поколение)',44,NULL,NULL),
(1123,'Escalade (III поколение)',44,NULL,NULL),
(1124,'SRX (I поколение)',44,NULL,NULL),
(1125,'SRX (II поколение)',44,NULL,NULL),
(1126,'SRX (II поколение рестайлинг)',44,NULL,NULL),
(1127,'STS (I поколение)',44,NULL,NULL),
(1128,'CS35 (I поколение)',70,NULL,NULL),
(1129,'Eado (I поколение)',70,NULL,NULL),
(1130,'Raeton (I поколение)',70,NULL,NULL),
(1131,'Arrizo 8',71,NULL,NULL),
(1132,'Bonus (II поколение)',71,NULL,NULL),
(1133,'CrossEastar (I поколение)',71,NULL,NULL),
(1134,'Eastar (I поколение)',71,NULL,NULL),
(1135,'Fora (I поколение)',71,NULL,NULL),
(1136,'Kimo (I поколение)',71,NULL,NULL),
(1137,'M11 (I поколение)',71,NULL,NULL),
(1138,'QQ6 (I поколение)',71,NULL,NULL),
(1139,'Tiggo (I поколение)',71,NULL,NULL),
(1140,'Tiggo (I поколение рестайлинг)',71,NULL,NULL),
(1141,'Aveo (I поколение рестайлинг)',30,NULL,NULL),
(1142,'Aveo (II поколение)',30,NULL,NULL),
(1143,'Camaro (V поколение)',30,NULL,NULL),
(1144,'Captiva (I поколение)',30,NULL,NULL),
(1145,'Captiva (I поколение 2-й рестайлинг)',30,NULL,NULL),
(1146,'Captiva (I поколение рестайлинг)',30,NULL,NULL),
(1147,'Cobalt (II поколение)',30,NULL,NULL),
(1148,'Corvette (C7)',30,NULL,NULL),
(1149,'Cruze (J300)',30,NULL,NULL),
(1150,'Cruze (J300 рестайлинг)',30,NULL,NULL),
(1151,'Epica (I поколение)',30,NULL,NULL),
(1152,'Lacetti (I поколение)',30,NULL,NULL),
(1153,'Lanos (I поколение)',30,NULL,NULL),
(1154,'Malibu (VIII поколение)',30,NULL,NULL),
(1155,'Orlando (I поколение)',30,NULL,NULL),
(1156,'Spark (I поколение)',30,NULL,NULL),
(1157,'Spark (II поколение)',30,NULL,NULL),
(1158,'Tahoe (GMT900)',30,NULL,NULL),
(1159,'Tracker (III поколение)',30,NULL,NULL),
(1160,'TrailBlazer (GMT800)',30,NULL,NULL),
(1161,'TrailBlazer (II поколение)',30,NULL,NULL),
(1162,'300C (I поколение)',39,NULL,NULL),
(1163,'Transit (8 мест)',15,NULL,NULL),
(1164,'300C SRT8 (I поколение)',39,NULL,NULL),
(1165,'300C SRT8 (II поколение)',39,NULL,NULL),
(1166,'Grand Voyager (V поколение)',39,NULL,NULL),
(1167,'Grand Voyager (V поколение рестайлинг)',39,NULL,NULL),
(1168,'PT Cruiser (I поколение)',39,NULL,NULL),
(1169,'Sebring (II поколение)',39,NULL,NULL),
(1170,'C-Elysee (I поколение)',29,NULL,NULL),
(1171,'C1 (I поколение 2-й рестайлинг)',29,NULL,NULL),
(1172,'C1 (I поколение рестайлинг)',29,NULL,NULL),
(1173,'C3 (I поколение)',29,NULL,NULL),
(1174,'C3 (II поколение)',29,NULL,NULL),
(1175,'C3 Picasso (I поколение)',29,NULL,NULL),
(1176,'C3 Picasso (I поколение рестайлинг)',29,NULL,NULL),
(1177,'C4 (I поколение)',29,NULL,NULL),
(1178,'C4 (II поколение)',29,NULL,NULL),
(1179,'C4 Aircross (I поколение)',29,NULL,NULL),
(1180,'C4 Picasso (I поколение)',29,NULL,NULL),
(1181,'C4 Picasso (II поколение)',29,NULL,NULL),
(1182,'C5 (II поколение)',29,NULL,NULL),
(1183,'C6 (I поколение)',29,NULL,NULL),
(1184,'C-Crosser (I поколение)',29,NULL,NULL),
(1185,'DS3 (I поколение)',29,NULL,NULL),
(1186,'DS3 (I поколение рестайлинг)',29,NULL,NULL),
(1187,'DS4 (I поколение)',29,NULL,NULL),
(1188,'DS5 (I поколение)',29,NULL,NULL),
(1189,'Grand C4 Picasso (I поколение)',29,NULL,NULL),
(1190,'Grand C4 Picasso (II поколение)',29,NULL,NULL),
(1191,'Xsara Picasso (I поколение)',29,NULL,NULL),
(1192,'Matiz (I поколение)',19,NULL,NULL),
(1193,'mi-DO (I поколение)',72,NULL,NULL),
(1194,'on-DO (I поколение)',72,NULL,NULL),
(1195,'Avenger (I поколение)',73,NULL,NULL),
(1196,'Caliber (I поколение)',73,NULL,NULL),
(1197,'Caliber SRT4 (I поколение)',73,NULL,NULL),
(1198,'Journey (I поколение)',73,NULL,NULL),
(1199,'Journey (I поколение рестайлинг)',73,NULL,NULL),
(1200,'Nitro (I поколение)',73,NULL,NULL),
(1201,'V2 (I поколение)',74,NULL,NULL),
(1202,'V5 (I поколение)',74,NULL,NULL),
(1203,'458 Italia (I поколение)',75,NULL,NULL),
(1204,'458 Speciale (I поколение)',75,NULL,NULL),
(1205,'458 Spider (I поколение)',75,NULL,NULL),
(1206,'599 GTB Fiorano (I поколение)',75,NULL,NULL),
(1207,'612 Scaglietti (I поколение)',75,NULL,NULL),
(1208,'California (I поколение)',75,NULL,NULL),
(1209,'California (I поколение рестайлинг)',75,NULL,NULL),
(1210,'F12berlinetta (I поколение)',75,NULL,NULL),
(1211,'F430 (I поколение)',75,NULL,NULL),
(1212,'FF (I поколение)',75,NULL,NULL),
(1213,'500 (II поколение)',16,NULL,NULL),
(1214,'Bravo (II поколение)',16,NULL,NULL),
(1215,'Croma (III поколение)',16,NULL,NULL),
(1216,'Freemont (I поколение)',16,NULL,NULL),
(1217,'Grande Punto (III поколение)',16,NULL,NULL),
(1218,'Linea (I поколение)',16,NULL,NULL),
(1219,'Panda (II поколение)',16,NULL,NULL),
(1220,'Punto (III поколение рестайлинг)',16,NULL,NULL),
(1221,'Punto Evo (III поколение рестайлинг)',16,NULL,NULL),
(1222,'Sedici (I поколение)',16,NULL,NULL),
(1223,'Doblo (I поколение рестайлинг)',16,NULL,NULL),
(1224,'C-MAX (I поколение рестайлинг)',15,NULL,NULL),
(1225,'EcoSport (II поколение)',15,NULL,NULL),
(1226,'Edge (I поколение рестайлинг)',15,NULL,NULL),
(1227,'Escape (II поколение)',15,NULL,NULL),
(1228,'Explorer (IV поколение)',15,NULL,NULL),
(1229,'Explorer (V поколение)',15,NULL,NULL),
(1230,'Fiesta (VII поколение)',15,NULL,NULL),
(1231,'Focus (III поколение)',15,NULL,NULL),
(1232,'Focus (III поколение рестайлинг)',15,NULL,NULL),
(1233,'Focus RS (II поколение)',15,NULL,NULL),
(1234,'Focus ST (II поколение рестайлинг)',15,NULL,NULL),
(1235,'Focus ST (III поколение)',15,NULL,NULL),
(1236,'Fusion (I поколение)',15,NULL,NULL),
(1237,'Galaxy (II поколение)',15,NULL,NULL),
(1238,'Galaxy (II поколение рестайлинг)',15,NULL,NULL),
(1239,'Grand C-MAX (I поколение)',15,NULL,NULL),
(1240,'Kuga (I поколение)',15,NULL,NULL),
(1241,'Kuga (II поколение)',15,NULL,NULL),
(1242,'Mondeo (IV поколение рестайлинг)',15,NULL,NULL),
(1243,'Mondeo (V поколение)',15,NULL,NULL),
(1244,'Mustang (VI поколение)',15,NULL,NULL),
(1245,'S-MAX (I поколение)',15,NULL,NULL),
(1246,'S-MAX (I поколение рестайлинг)',15,NULL,NULL),
(1247,'Ranger (III поколение)',15,NULL,NULL),
(1248,'Ranger (IV поколение)',15,NULL,NULL),
(1249,'Tourneo (VII поколение)',15,NULL,NULL),
(1250,'Emgrand (I поколение)',76,NULL,NULL),
(1251,'MK (I поколение)',76,NULL,NULL),
(1252,'MK Cross (I поколение)',76,NULL,NULL),
(1253,'Hover (I поколение рестайлинг)',77,NULL,NULL),
(1254,'Hover (II поколение)',77,NULL,NULL),
(1255,'Wingle (II поколение)',77,NULL,NULL),
(1256,'H8 (I поколение)',78,NULL,NULL),
(1257,'Accord (IX поколение)',79,NULL,NULL),
(1258,'Accord (VIII поколение)',79,NULL,NULL),
(1259,'Accord (VIII поколение рестайлинг)',79,NULL,NULL),
(1260,'Civic (IX поколение)',79,NULL,NULL),
(1261,'Civic (IX поколение рестайлинг)',79,NULL,NULL),
(1262,'Civic (VIII поколение рестайлинг)',79,NULL,NULL),
(1263,'Civic Type-R (VIII поколение)',79,NULL,NULL),
(1264,'Crosstour (I поколение)',79,NULL,NULL),
(1265,'Crosstour (I поколение рестайлинг)',79,NULL,NULL),
(1266,'CR-V (III поколение)',79,NULL,NULL),
(1267,'CR-V (III поколение рестайлинг)',79,NULL,NULL),
(1268,'CR-V (IV поколение)',79,NULL,NULL),
(1269,'Jazz (II поколение)',79,NULL,NULL),
(1270,'Jazz (II поколение рестайлинг)',79,NULL,NULL),
(1271,'Legend (IV поколение рестайлинг)',79,NULL,NULL),
(1272,'Pilot (II поколение)',79,NULL,NULL),
(1273,'Pilot (II поколение рестайлинг)',79,NULL,NULL),
(1274,'Accent (II поколение)',48,NULL,NULL),
(1275,'Elantra (IV поколение)',48,NULL,NULL),
(1276,'Elantra (V поколение)',48,NULL,NULL),
(1277,'Elantra (V поколение рестайлинг)',48,NULL,NULL),
(1278,'Elantra XD (III поколение)',48,NULL,NULL),
(1279,'EQUUS (II поколение)',48,NULL,NULL),
(1280,'EQUUS (II поколение рестайлинг)',48,NULL,NULL),
(1281,'Genesis (I поколение)',48,NULL,NULL),
(1282,'Genesis (I поколение рестайлинг)',48,NULL,NULL),
(1283,'Genesis (II поколение)',48,NULL,NULL),
(1284,'Getz (I поколение)',48,NULL,NULL),
(1285,'Grand Santa Fe (III поколение)',48,NULL,NULL),
(1286,'Grandeur (IV поколение)',48,NULL,NULL),
(1287,'Grandeur (V поколение)',48,NULL,NULL),
(1288,'i20 (I поколение)',48,NULL,NULL),
(1289,'i30 (I поколение)',48,NULL,NULL),
(1290,'i30 (II поколение)',48,NULL,NULL),
(1291,'i40 (I поколение)',48,NULL,NULL),
(1292,'ix35 (I поколение)',48,NULL,NULL),
(1293,'ix35 (I поколение рестайлинг)',48,NULL,NULL),
(1294,'ix55 (I поколение)',48,NULL,NULL),
(1295,'Matrix (I поколение)',48,NULL,NULL),
(1296,'NF Sonata (V поколение)',48,NULL,NULL),
(1297,'Santa Fe (II поколение)',48,NULL,NULL),
(1298,'Santa Fe (II поколение рестайлинг)',48,NULL,NULL),
(1299,'Santa Fe (III поколение)',48,NULL,NULL),
(1300,'Santa Fe Classic (I поколение)',48,NULL,NULL),
(1301,'Solaris (I поколение)',48,NULL,NULL),
(1302,'Solaris (I поколение рестайлинг)',48,NULL,NULL),
(1303,'Sonata (IV поколение)',48,NULL,NULL),
(1304,'Sonata',48,NULL,NULL),
(1305,'Tucson (I поколение)',48,NULL,NULL),
(1306,'Veloster (I поколение)',48,NULL,NULL),
(1308,'EX (I поколение)',40,NULL,NULL),
(1309,'FX (II поколение)',40,NULL,NULL),
(1310,'FX (II поколение рестайлинг)',40,NULL,NULL),
(1311,'G (II поколение рестайлинг)',40,NULL,NULL),
(1312,'JX (I поколение)',40,NULL,NULL),
(1313,'M (Y50)',40,NULL,NULL),
(1314,'M (Y51)',40,NULL,NULL),
(1315,'Q50 (III поколение)',40,NULL,NULL),
(1316,'Q60 (II поколение рестайлинг)',40,NULL,NULL),
(1317,'QX (II поколение)',40,NULL,NULL),
(1318,'QX (III поколение)',40,NULL,NULL),
(1319,'QX50 (I поколение)',40,NULL,NULL),
(1320,'QX60 (I поколение)',40,NULL,NULL),
(1321,'QX70 (II поколение рестайлинг)',40,NULL,NULL),
(1322,'QX80 (III поколение)',40,NULL,NULL),
(1323,'F-Type (I поколение)',45,NULL,NULL),
(1324,'XE (I поколение)',45,NULL,NULL),
(1325,'XF (I поколение)',45,NULL,NULL),
(1326,'XF (I поколение рестайлинг)',45,NULL,NULL),
(1327,'XFR (I поколение)',45,NULL,NULL),
(1328,'XFR (I поколение рестайлинг)',45,NULL,NULL),
(1329,'XFR-S (I поколение рестайлинг)',45,NULL,NULL),
(1330,'XJ (V поколение)',45,NULL,NULL),
(1331,'XJR (V поколение)',45,NULL,NULL),
(1332,'XK (III поколение)',45,NULL,NULL),
(1333,'XK (III поколение рестайлинг)',45,NULL,NULL),
(1334,'XKR (III поколение)',45,NULL,NULL),
(1335,'XKR (III поколение рестайлинг)',45,NULL,NULL),
(1336,'XKR-S (III поколение рестайлинг)',45,NULL,NULL),
(1337,'X-Type (I поколение)',45,NULL,NULL),
(1338,'Cherokee (KK)',80,NULL,NULL),
(1339,'Cherokee (KL)',80,NULL,NULL),
(1340,'Commander (I поколение)',80,NULL,NULL),
(1341,'Compass (I поколение)',80,NULL,NULL),
(1342,'Compass (I поколение рестайлинг)',80,NULL,NULL),
(1343,'Grand Cherokee (WK)',80,NULL,NULL),
(1344,'Grand Cherokee (WK2)',80,NULL,NULL),
(1345,'Grand Cherokee (WK2 рестайлинг)',80,NULL,NULL),
(1346,'Grand Cherokee SRT8 (WK)',80,NULL,NULL),
(1347,'Grand Cherokee SRT8 (WK2)',80,NULL,NULL),
(1348,'Grand Cherokee SRT8 (WK2 рестайлинг)',80,NULL,NULL),
(1349,'Liberty (II поколение)',80,NULL,NULL),
(1350,'Wrangler (II поколение)',80,NULL,NULL),
(1351,'Cadenza (I поколение)',12,NULL,NULL),
(1352,'Carens (III поколение)',12,NULL,NULL),
(1353,'Carnival (II поколение)',12,NULL,NULL),
(1354,'cee\'d (I поколение рестайлинг)',12,NULL,NULL),
(1355,'cee\'d (II поколение)',12,NULL,NULL),
(1356,'cee\'d GT (II поколение)',12,NULL,NULL),
(1357,'Cerato (II поколение)',12,NULL,NULL),
(1358,'Cerato (III поколение)',12,NULL,NULL),
(1359,'Magentis (III поколение)',12,NULL,NULL),
(1360,'Mohave (I поколение)',12,NULL,NULL),
(1361,'Opirus (I поколение рестайлинг)',12,NULL,NULL),
(1362,'Optima',12,NULL,NULL),
(1363,'Optima (III поколение рестайлинг)',12,NULL,NULL),
(1364,'Picanto (I поколение рестайлинг)',12,NULL,NULL),
(1365,'Picanto (II поколение)',12,NULL,NULL),
(1366,'Quoris (I поколение)',12,NULL,NULL),
(1367,'Rio (II поколение рестайлинг)',12,NULL,NULL),
(1368,'Rio (III поколение)',12,NULL,NULL),
(1369,'Sorento (I поколение рестайлинг)',12,NULL,NULL),
(1370,'Sorento (II поколение)',12,NULL,NULL),
(1371,'Sorento (II поколение рестайлинг)',12,NULL,NULL),
(1372,'Soul (I поколение)',12,NULL,NULL),
(1373,'Soul (I поколение рестайлинг)',12,NULL,NULL),
(1374,'Soul (II поколение)',12,NULL,NULL),
(1375,'Spectra (I поколение)',12,NULL,NULL),
(1376,'Sportage (II поколение)',12,NULL,NULL),
(1377,'Sportage (III поколение)',12,NULL,NULL),
(1378,'Sportage (III поколение рестайлинг)',12,NULL,NULL),
(1379,'Venga (I поколение)',12,NULL,NULL),
(1380,'2107 (I поколение)',42,NULL,NULL),
(1381,'4x4 (I поколение)',42,NULL,NULL),
(1382,'Granta (I поколение)',42,NULL,NULL),
(1383,'Kalina (I поколение)',42,NULL,NULL),
(1384,'Kalina (I поколение рестайлинг)',42,NULL,NULL),
(1385,'Priora (I поколение)',42,NULL,NULL),
(1386,'Priora (I поколение рестайлинг)',42,NULL,NULL),
(1387,'Samara (I поколение)',42,NULL,NULL),
(1388,'Largus (I поколение)',42,NULL,NULL),
(1389,'Aventador (I поколение)',81,NULL,NULL),
(1390,'Gallardo (I поколение рестайлинг)',81,NULL,NULL),
(1391,'Huracan (I поколение)',81,NULL,NULL),
(1392,'Murcielago (I поколение)',81,NULL,NULL),
(1393,'Discovery (IV поколение)',59,NULL,NULL),
(1394,'Discovery (IV поколение рестайлинг)',59,NULL,NULL),
(1395,'Freelander (II поколение)',59,NULL,NULL),
(1396,'Freelander (II поколение 2-й рестайлинг)',59,NULL,NULL),
(1397,'Freelander (II поколение рестайлинг)',59,NULL,NULL),
(1398,'Range Rover (III поколение 2-й рестайлинг)',59,NULL,NULL),
(1399,'Range Rover (IV поколение)',59,NULL,NULL),
(1400,'Range Rover Evoque (I поколение)',59,NULL,NULL),
(1401,'Range Rover Sport (I поколение рестайлинг)',59,NULL,NULL),
(1402,'Range Rover Sport (II поколение)',59,NULL,NULL),
(1403,'CT (I поколение)',4,NULL,NULL),
(1404,'CT (I поколение рестайлинг)',4,NULL,NULL),
(1405,'ES (V поколение рестайлинг)',4,NULL,NULL),
(1406,'ES',4,NULL,NULL),
(1407,'GS (III поколение)',4,NULL,NULL),
(1408,'GS (IV поколение)',4,NULL,NULL),
(1409,'GX (II поколение)',4,NULL,NULL),
(1410,'GX (II поколение рестайлинг)',4,NULL,NULL),
(1411,'IS (II поколение)',4,NULL,NULL),
(1412,'IS (III поколение)',4,NULL,NULL),
(1413,'IS F (II поколение)',4,NULL,NULL),
(1414,'LFA (I поколение)',4,NULL,NULL),
(1415,'LS (IV поколение)',4,NULL,NULL),
(1416,'LS (IV поколение рестайлинг)',4,NULL,NULL),
(1417,'LX (III поколение)',4,NULL,NULL),
(1418,'LX (III поколение рестайлинг)',4,NULL,NULL),
(1419,'NX (I поколение)',4,NULL,NULL),
(1420,'RC (I поколение)',4,NULL,NULL),
(1421,'RC F (I поколение)',4,NULL,NULL),
(1422,'RX (II поколение рестайлинг)',4,NULL,NULL),
(1423,'RX (III поколение)',4,NULL,NULL),
(1424,'RX (III поколение рестайлинг)',4,NULL,NULL),
(1425,'SC (II поколение)',4,NULL,NULL),
(1426,'Smily (I поколение)',82,NULL,NULL),
(1427,'X60 (I поколение)',82,NULL,NULL),
(1428,'Elise (II поколение)',83,NULL,NULL),
(1429,'Elise (II поколение рестайлинг)',83,NULL,NULL),
(1430,'Europa (I поколение)',83,NULL,NULL),
(1431,'Evora (I поколение)',83,NULL,NULL),
(1432,'Exige (II поколение)',83,NULL,NULL),
(1433,'Exige (II поколение рестайлинг)',83,NULL,NULL),
(1434,'7 SUV (I поколение)',95,NULL,NULL),
(1435,'GranCabrio (I поколение)',84,NULL,NULL),
(1436,'GranTurismo (I поколение)',84,NULL,NULL),
(1437,'Quattroporte (VI поколение)',84,NULL,NULL),
(1438,'2 (II поколение)',85,NULL,NULL),
(1439,'2 (II поколение рестайлинг)',85,NULL,NULL),
(1440,'3 (II поколение рестайлинг)',85,NULL,NULL),
(1441,'3 (III поколение)',85,NULL,NULL),
(1442,'3 MPS (II поколение)',85,NULL,NULL),
(1443,'5 (II поколение рестайлинг)',85,NULL,NULL),
(1444,'5 (III поколение)',85,NULL,NULL),
(1445,'6 (II поколение)',85,NULL,NULL),
(1446,'6 (II поколение рестайлинг)',85,NULL,NULL),
(1447,'6 (III поколение)',85,NULL,NULL),
(1448,'CX-5 (I поколение)',85,NULL,NULL),
(1449,'CX-7 (I поколение)',85,NULL,NULL),
(1450,'CX-9 (I поколение рестайлинг)',85,NULL,NULL),
(1451,'MX-5 (III поколение рестайлинг)',85,NULL,NULL),
(1452,'MX-5 (III поколение 2-й рестайлинг)',85,NULL,NULL),
(1453,'MX-5 (IV поколение)',85,NULL,NULL),
(1454,'A-Класс (W169 рестайлинг)',14,NULL,NULL),
(1455,'A-Класс (W176)',14,NULL,NULL),
(1456,'A-Класс AMG (W176)',14,NULL,NULL),
(1457,'B-Класс (W245)',14,NULL,NULL),
(1458,'B-Класс (W246)',14,NULL,NULL),
(1459,'C-Класс (W204/S204/С204 рестайлинг)',14,NULL,NULL),
(1460,'C-Класс (W205/S205/C205)',14,NULL,NULL),
(1461,'C-Класс AMG (W204/S204)',14,NULL,NULL),
(1462,'C-Класс AMG (W204/S204/С204 рестайлинг)',14,NULL,NULL),
(1463,'CLA-Класс AMG (C117)',14,NULL,NULL),
(1464,'CLA-Класс (C117)',14,NULL,NULL),
(1465,'CLC-Класс (CL203 рестайлинг)',14,NULL,NULL),
(1466,'CL-Класс (C216)',14,NULL,NULL),
(1467,'CL-Класс (C216 рестайлинг)',14,NULL,NULL),
(1468,'CL-Класс AMG (C216)',14,NULL,NULL),
(1469,'CL-Класс AMG (C216 рестайлинг)',14,NULL,NULL),
(1470,'CLS-Класс (C218/X218)',14,NULL,NULL),
(1471,'CLS-Класс (C218/X218 рестайлинг)',14,NULL,NULL),
(1472,'CLS-Класс AMG (C218/X218)',14,NULL,NULL),
(1473,'CLS-Класс AMG (C218/X218 рестайлинг)',14,NULL,NULL),
(1474,'E-Класс (W212/S212/C207/A207 рестайлинг)',14,NULL,NULL),
(1475,'E-Класс AMG (W212/S212/C207/A207/E200)',14,NULL,NULL),
(1476,'E-Класс AMG (W212/S212/C207/A207 рестайлинг)',14,NULL,NULL),
(1477,'G-Класс (W463 рестайлинг)',14,NULL,NULL),
(1478,'G-Класс (W463 2-й рестайлинг)',14,NULL,NULL),
(1479,'G-Класс AMG (W463 рестайлинг)',14,NULL,NULL),
(1480,'G-Класс AMG (W463 2-й рестайлинг)',14,NULL,NULL),
(1481,'GLA-Класс AMG (X156)',14,NULL,NULL),
(1482,'GLA-Класс (X156)',14,NULL,NULL),
(1483,'GL-Класс (X164)',14,NULL,NULL),
(1484,'GL-Класс (X166)',14,NULL,NULL),
(1485,'GL-Класс AMG (X166)',14,NULL,NULL),
(1486,'GLK-Класс (X204)',14,NULL,NULL),
(1487,'GLK-Класс (X204 рестайлинг)',14,NULL,NULL),
(1488,'M-Класс (W163)',14,NULL,NULL),
(1489,'M-Класс (W164 рестайлинг)',14,NULL,NULL),
(1490,'M-Класс (W166)',14,NULL,NULL),
(1491,'M-Класс AMG (W164 рестайлинг)',14,NULL,NULL),
(1492,'M-Класс AMG (W166)',14,NULL,NULL),
(1493,'R-Класс (W251)',14,NULL,NULL),
(1494,'R-Класс (W251 рестайлинг)',14,NULL,NULL),
(1495,'S-Класс (C217)',14,NULL,NULL),
(1496,'S-Класс (W221)',14,NULL,NULL),
(1497,'S-Класс (W221 рестайлинг)',14,NULL,NULL),
(1498,'S-Класс (W222)',14,NULL,NULL),
(1499,'S-Класс AMG (C217)',14,NULL,NULL),
(1500,'S-Класс AMG (W221 рестайлинг)',14,NULL,NULL),
(1501,'S-Класс AMG (W222)',14,NULL,NULL),
(1502,'SL-Класс (R230 рестайлинг)',14,NULL,NULL),
(1503,'SL-Класс AMG (R230 рестайлинг)',14,NULL,NULL),
(1504,'SL-Класс AMG (R231)',14,NULL,NULL),
(1505,'SLK-Класс (R171)',14,NULL,NULL),
(1506,'SLK-Класс (R172)',14,NULL,NULL),
(1507,'SLK-Класс AMG (R172)',14,NULL,NULL),
(1508,'SLS AMG (C197)',14,NULL,NULL),
(1509,'Cooper Clubvan (I поколение рестайлинг)',86,NULL,NULL),
(1510,'One Clubvan (I поколение рестайлинг)',86,NULL,NULL),
(1511,'Cooper (I поколение рестайлинг)',86,NULL,NULL),
(1512,'Cooper (II поколение)',86,NULL,NULL),
(1513,'Cooper S Paceman (I поколение)',86,NULL,NULL),
(1514,'Cooper Clubman (I поколение рестайлинг)',86,NULL,NULL),
(1515,'Cooper Countryman (I поколение)',86,NULL,NULL),
(1516,'Cooper S (I поколение рестайлинг)',86,NULL,NULL),
(1517,'Cooper S (II поколение)',86,NULL,NULL),
(1518,'Cooper S Roadster (I поколение рестайлинг)',86,NULL,NULL),
(1519,'Cooper S Clubman (I поколение рестайлинг)',86,NULL,NULL),
(1520,'Cooper S Countryman (I поколение)',86,NULL,NULL),
(1521,'John Cooper Works (I поколение рестайлинг)',86,NULL,NULL),
(1522,'John Cooper Works Clubman (I поколение рестайлинг)',86,NULL,NULL),
(1523,'John Cooper Works Coupe (I поколение рестайлинг)',86,NULL,NULL),
(1524,'One (I поколение рестайлинг)',86,NULL,NULL),
(1525,'One Clubman (I поколение рестайлинг)',86,NULL,NULL),
(1526,'L200 (IV поколение)',37,NULL,NULL),
(1527,'ASX (I поколение)',37,NULL,NULL),
(1528,'ASX (I поколение рестайлинг)',37,NULL,NULL),
(1529,'Colt (Z30 рестайлинг)',37,NULL,NULL),
(1530,'Galant (IX поколение)',37,NULL,NULL),
(1531,'Grandis (I поколение)',37,NULL,NULL),
(1532,'i-MiEV (I)',37,NULL,NULL),
(1533,'Lancer (X поколение)',37,NULL,NULL),
(1534,'Lancer Classic (IX поколение)',37,NULL,NULL),
(1535,'Lancer Evolution (X поколение)',37,NULL,NULL),
(1536,'Lancer Ralliart (X поколение)',37,NULL,NULL),
(1537,'Outlander (III поколение)',37,NULL,NULL),
(1538,'Outlander XL (I поколение рестайлинг)',37,NULL,NULL),
(1539,'Pajero (IV поколение)',37,NULL,NULL),
(1540,'Pajero Sport (I поколение)',37,NULL,NULL),
(1541,'Pajero Sport (II поколение)',37,NULL,NULL),
(1542,'Navara (D40)',57,NULL,NULL),
(1543,'Navara (D40 рестайлинг)',57,NULL,NULL),
(1544,'NP300 (I поколение)',57,NULL,NULL),
(1545,'Almera (G11)',57,NULL,NULL),
(1546,'Almera Classic (N17)',57,NULL,NULL),
(1547,'GT-R (R35 3-й рестайлинг)',57,NULL,NULL),
(1548,'GT-R (R35 рестайлинг)',57,NULL,NULL),
(1549,'Juke (YF15)',57,NULL,NULL),
(1550,'Juke (YF15 рестайлинг)',57,NULL,NULL),
(1551,'Micra (K12)',57,NULL,NULL),
(1552,'Murano (II поколение)',57,NULL,NULL),
(1553,'Murano (II поколение рестайлинг)',57,NULL,NULL),
(1554,'Note (I поколение рестайлинг)',57,NULL,NULL),
(1555,'Pathfinder (R51)',57,NULL,NULL),
(1556,'Pathfinder (R51 рестайлинг)',57,NULL,NULL),
(1557,'Pathfinder (R52)',57,NULL,NULL),
(1558,'Patrol (Y61)',57,NULL,NULL),
(1559,'Patrol (Y62)',57,NULL,NULL),
(1560,'Qashqai (I поколение рестайлинг)',57,NULL,NULL),
(1561,'Qashqai (II поколение)',57,NULL,NULL),
(1562,'Qashqai+2 (I поколение рестайлинг)',57,NULL,NULL),
(1563,'Sentra (B17)',57,NULL,NULL),
(1564,'Teana (J32)',57,NULL,NULL),
(1565,'Teana (L33)',57,NULL,NULL),
(1566,'Terrano (III поколение)',57,NULL,NULL),
(1567,'Tiida (I поколение)',57,NULL,NULL),
(1568,'Tiida (I поколение рестайлинг)',57,NULL,NULL),
(1569,'X-Trail (T31)',57,NULL,NULL),
(1570,'X-Trail (T31 рестайлинг)',57,NULL,NULL),
(1571,'Antara (I поколение)',54,NULL,NULL),
(1572,'Antara (I поколение рестайлинг)',54,NULL,NULL),
(1573,'Astra (H)',54,NULL,NULL),
(1574,'Astra (J)',54,NULL,NULL),
(1575,'Astra (J рестайлинг)',54,NULL,NULL),
(1576,'Astra OPC (H)',54,NULL,NULL),
(1577,'Astra OPC (J)',54,NULL,NULL),
(1578,'Corsa (D 2-й рестайлинг)',54,NULL,NULL),
(1579,'Corsa (D рестайлинг)',54,NULL,NULL),
(1580,'Corsa OPC (D)',54,NULL,NULL),
(1581,'Insignia (I поколение)',54,NULL,NULL),
(1582,'Insignia (I поколение рестайлинг)',54,NULL,NULL),
(1583,'Insignia OPC (I поколение)',54,NULL,NULL),
(1584,'Insignia OPC (I поколение рестайлинг)',54,NULL,NULL),
(1585,'Meriva (I поколение рестайлинг)',54,NULL,NULL),
(1586,'Meriva (II поколение)',54,NULL,NULL),
(1587,'Meriva (II поколение рестайлинг)',54,NULL,NULL),
(1588,'Meriva OPC (I поколение рестайлинг)',54,NULL,NULL),
(1589,'Mokka (I поколение)',54,NULL,NULL),
(1590,'Zafira (B)',54,NULL,NULL),
(1591,'Zafira (C)',54,NULL,NULL),
(1592,'Zafira OPC (B)',54,NULL,NULL),
(1593,'107 (I поколение 2-й рестайлинг)',6,NULL,NULL),
(1594,'107 (I поколение рестайлинг)',6,NULL,NULL),
(1595,'2008 (I поколение)',6,NULL,NULL),
(1596,'206 (I поколение)',6,NULL,NULL),
(1597,'207 (I поколение рестайлинг)',6,NULL,NULL),
(1598,'207 RC (I поколение рестайлинг)',6,NULL,NULL),
(1599,'208 (I поколение)',6,NULL,NULL),
(1600,'208 GTi (I поколение)',6,NULL,NULL),
(1601,'3008 (I поколение)',6,NULL,NULL),
(1602,'3008 (I поколение рестайлинг)',6,NULL,NULL),
(1603,'301 (I поколение)',6,NULL,NULL),
(1604,'308 (I поколение рестайлинг)',6,NULL,NULL),
(1605,'308 (II поколение)',6,NULL,NULL),
(1606,'4007 (I поколение)',6,NULL,NULL),
(1607,'4008 (I поколение)',6,NULL,NULL),
(1608,'407 (I поколение)',6,NULL,NULL),
(1609,'407 (I поколение рестайлинг)',6,NULL,NULL),
(1610,'408 (I поколение)',6,NULL,NULL),
(1611,'508 (I поколение)',6,NULL,NULL),
(1612,'RCZ (I поколение)',6,NULL,NULL),
(1613,'RCZ (I поколение рестайлинг)',6,NULL,NULL),
(1614,'911 Carrera (991)',46,NULL,NULL),
(1615,'911 Carrera (997)',46,NULL,NULL),
(1616,'911 Carrera 4 (991)',46,NULL,NULL),
(1617,'911 Carrera S (991)',46,NULL,NULL),
(1618,'911 GT3 (991)',46,NULL,NULL),
(1619,'911 Targa 4 (991)',46,NULL,NULL),
(1620,'911 Targa 4S (991)',46,NULL,NULL),
(1621,'911 Turbo (991)',46,NULL,NULL),
(1622,'911 Turbo S (991)',46,NULL,NULL),
(1623,'918 (I поколение)',46,NULL,NULL),
(1624,'Boxster (981)',46,NULL,NULL),
(1625,'Boxster (987)',46,NULL,NULL),
(1626,'Boxster GTS (981)',46,NULL,NULL),
(1627,'Boxster S (981)',46,NULL,NULL),
(1628,'Cayenne (II поколение)',46,NULL,NULL),
(1629,'Cayenne Diesel (II поколение)',46,NULL,NULL),
(1630,'Cayenne Diesel (II поколение рестайлинг)',46,NULL,NULL),
(1631,'Cayenne GTS (II поколение)',46,NULL,NULL),
(1632,'Cayenne S (II поколение)',46,NULL,NULL),
(1633,'Cayenne S (II поколение рестайлинг)',46,NULL,NULL),
(1634,'Cayenne S Hybrid (II поколение)',46,NULL,NULL),
(1635,'Cayenne S Hybrid (II поколение рестайлинг)',46,NULL,NULL),
(1636,'Cayenne Turbo (II поколение)',46,NULL,NULL),
(1637,'Cayenne Turbo (II поколение рестайлинг)',46,NULL,NULL),
(1638,'Cayenne Turbo S (II поколение)',46,NULL,NULL),
(1639,'Cayenne S Diesel (II поколение рестайлинг)',46,NULL,NULL),
(1640,'Cayman (981)',46,NULL,NULL),
(1641,'Cayman (987)',46,NULL,NULL),
(1642,'Cayman GTS (981)',46,NULL,NULL),
(1643,'Cayman S (981)',46,NULL,NULL),
(1644,'Macan S (I поколение)',46,NULL,NULL),
(1645,'Macan S Diesel (I поколение)',46,NULL,NULL),
(1646,'Macan Turbo (I поколение)',46,NULL,NULL),
(1647,'Panamera (E2B)',46,NULL,NULL),
(1648,'Panamera 4 (E2B)',46,NULL,NULL),
(1649,'Panamera 4S (E2B)',46,NULL,NULL),
(1650,'Panamera Diesel (E2B)',46,NULL,NULL),
(1651,'Panamera GTS (E2B)',46,NULL,NULL),
(1652,'Panamera S (E2B)',46,NULL,NULL),
(1653,'Panamera S Hybrid (E2B)',46,NULL,NULL),
(1654,'Panamera Turbo (E2B)',46,NULL,NULL),
(1655,'Kangoo (I поколение рестайлинг)',51,NULL,NULL),
(1656,'Kangoo (II поколение)',51,NULL,NULL),
(1657,'Clio (III поколение рестайлинг)',51,NULL,NULL),
(1658,'Clio RS (IV поколение)',51,NULL,NULL),
(1659,'Duster (I поколение)',51,NULL,NULL),
(1660,'Espace (IV поколение рестайлинг)',51,NULL,NULL),
(1661,'Fluence (I поколение)',51,NULL,NULL),
(1662,'Fluence (I поколение рестайлинг)',51,NULL,NULL),
(1663,'Grand Scenic (II поколение)',51,NULL,NULL),
(1664,'Koleos (I поколение)',51,NULL,NULL),
(1665,'Koleos (I поколение 2-й рестайлинг)',51,NULL,NULL),
(1666,'Koleos (I поколение рестайлинг)',51,NULL,NULL),
(1667,'Laguna (III поколение)',51,NULL,NULL),
(1668,'Laguna (III поколение рестайлинг)',51,NULL,NULL),
(1669,'Latitude (I поколение)',51,NULL,NULL),
(1670,'Latitude (I поколение рестайлинг)',51,NULL,NULL),
(1671,'Logan (I поколение рестайлинг)',51,NULL,NULL),
(1672,'Logan (II поколение)',51,NULL,NULL),
(1673,'Megane (III поколение)',51,NULL,NULL),
(1674,'Megane (III поколение 2-й рестайлинг)',51,NULL,NULL),
(1675,'Megane (III поколение рестайлинг)',51,NULL,NULL),
(1676,'Megane RS (III поколение)',51,NULL,NULL),
(1677,'Megane RS (III поколение рестайлинг)',51,NULL,NULL),
(1678,'Sandero (I поколение)',51,NULL,NULL),
(1679,'Sandero (II поколение)',51,NULL,NULL),
(1680,'Scenic (II поколение рестайлинг)',51,NULL,NULL),
(1681,'Scenic (III поколение)',51,NULL,NULL),
(1682,'Scenic (III поколение 2-й рестайлинг)',51,NULL,NULL),
(1683,'Scenic (III поколение рестайлинг)',51,NULL,NULL),
(1684,'Symbol (II поколение)',51,NULL,NULL),
(1685,'Ghost (I поколение)',87,NULL,NULL),
(1686,'Phantom (I поколение)',87,NULL,NULL),
(1687,'Phantom (I поколение рестайлинг)',87,NULL,NULL),
(1688,'Wraith (I поколение)',87,NULL,NULL),
(1689,'Alhambra (II поколение)',88,NULL,NULL),
(1690,'Altea (I поколение)',88,NULL,NULL),
(1691,'Altea Freetrack (I поколение)',88,NULL,NULL),
(1692,'Altea XL (I поколение)',88,NULL,NULL),
(1693,'Exeo (I поколение)',88,NULL,NULL),
(1694,'Ibiza (IV поколение)',88,NULL,NULL),
(1695,'Ibiza (IV поколение рестайлинг)',88,NULL,NULL),
(1696,'Ibiza Cupra (IV поколение)',88,NULL,NULL),
(1697,'Ibiza FR (IV поколение)',88,NULL,NULL),
(1698,'Ibiza FR (IV поколение рестайлинг)',88,NULL,NULL),
(1699,'Leon (II поколение)',88,NULL,NULL),
(1700,'Leon (III поколение)',88,NULL,NULL),
(1701,'Leon Cupra (II поколение)',88,NULL,NULL),
(1702,'Leon Cupra (III поколение)',88,NULL,NULL),
(1703,'Leon FR (II поколение)',88,NULL,NULL),
(1704,'Toledo (III поколение)',88,NULL,NULL),
(1705,'Toledo (IV поколение)',88,NULL,NULL),
(1706,'Fabia (II поколение)',58,NULL,NULL),
(1707,'Fabia (II поколение рестайлинг)',58,NULL,NULL),
(1708,'Fabia RS (II поколение рестайлинг)',58,NULL,NULL),
(1709,'Fabia Scout (II поколение рестайлинг)',58,NULL,NULL),
(1710,'Octavia (II поколение рестайлинг)',58,NULL,NULL),
(1711,'Octavia (III поколение)',58,NULL,NULL),
(1712,'Octavia RS (II поколение рестайлинг)',58,NULL,NULL),
(1713,'Octavia RS (III поколение)',58,NULL,NULL),
(1714,'Octavia Scout (II поколение рестайлинг)',58,NULL,NULL),
(1715,'Octavia Tour (I поколение)',58,NULL,NULL),
(1716,'Rapid (I поколение)',58,NULL,NULL),
(1717,'Roomster (I поколение)',58,NULL,NULL),
(1718,'Roomster (I поколение рестайлинг)',58,NULL,NULL),
(1719,'Roomster Scout (I поколение рестайлинг)',58,NULL,NULL),
(1720,'Superb (II поколение)',58,NULL,NULL),
(1721,'Superb (II поколение рестайлинг)',58,NULL,NULL),
(1722,'Yeti (I поколение)',58,NULL,NULL),
(1723,'Yeti (I поколение рестайлинг)',58,NULL,NULL),
(1724,'fortwo (II поколение рестайлинг)',96,NULL,NULL),
(1725,'Actyon Sports (I поколение)',36,NULL,NULL),
(1726,'Actyon Sports (I поколение рестайлинг)',36,NULL,NULL),
(1727,'Actyon (I поколение)',36,NULL,NULL),
(1728,'Actyon (II поколение)',36,NULL,NULL),
(1729,'Actyon (II поколение рестайлинг)',36,NULL,NULL),
(1730,'Kyron (I поколение)',36,NULL,NULL),
(1731,'Rexton (II поколение)',36,NULL,NULL),
(1732,'Rodius (I поколение)',36,NULL,NULL),
(1733,'Stavic (II поколение)',36,NULL,NULL),
(1734,'BRZ (I поколение)',89,NULL,NULL),
(1735,'Forester (III поколение)',89,NULL,NULL),
(1736,'Forester (IV поколение)',89,NULL,NULL),
(1737,'Impreza (III поколение)',89,NULL,NULL),
(1738,'Impreza (IV поколение)',89,NULL,NULL),
(1739,'WRX (III поколение)',89,NULL,NULL),
(1740,'WRX (IV поколение)',89,NULL,NULL),
(1741,'WRX STI (III поколение)',89,NULL,NULL),
(1742,'WRX STI (IV поколение)',89,NULL,NULL),
(1743,'Impreza XV (III поколение)',89,NULL,NULL),
(1744,'Legacy (V поколение)',89,NULL,NULL),
(1745,'Legacy (V поколение рестайлинг)',89,NULL,NULL),
(1746,'Outback (III поколение)',89,NULL,NULL),
(1747,'Outback (IV поколение)',89,NULL,NULL),
(1748,'Outback (IV поколение рестайлинг)',89,NULL,NULL),
(1749,'Tribeca (II поколение)',89,NULL,NULL),
(1750,'XV (IV поколение)',89,NULL,NULL),
(1751,'Grand Vitara (II поколение)',90,NULL,NULL),
(1752,'Grand Vitara (II поколение рестайлинг)',90,NULL,NULL),
(1753,'Jimny (FJ)',90,NULL,NULL),
(1754,'Jimny (FJ рестайлинг)',90,NULL,NULL),
(1755,'Kizashi (I поколение)',90,NULL,NULL),
(1756,'Splash (I поколение)',90,NULL,NULL),
(1757,'Splash (I поколение рестайлинг)',90,NULL,NULL),
(1758,'Swift (IV поколение)',90,NULL,NULL),
(1759,'Swift (V поколение)',90,NULL,NULL),
(1760,'Swift (V поколение рестайлинг)',90,NULL,NULL),
(1761,'SX4 (I поколение)',90,NULL,NULL),
(1762,'SX4 (I поколение рестайлинг)',90,NULL,NULL),
(1763,'SX4 (II поколение)',90,NULL,NULL),
(1764,'Hilux (VI поколение 2-й рестайлинг)',5,NULL,NULL),
(1765,'Hilux (VI поколение рестайлинг)',5,NULL,NULL),
(1766,'Alphard (II поколение)',5,NULL,NULL),
(1767,'Auris (I поколение)',5,NULL,NULL),
(1768,'Auris (I поколение рестайлинг)',5,NULL,NULL),
(1769,'Auris (II поколение)',5,NULL,NULL),
(1770,'Avensis (III поколение)',5,NULL,NULL),
(1771,'Avensis (III поколение рестайлинг)',5,NULL,NULL),
(1772,'Camry (VI поколение рестайлинг)',5,NULL,NULL),
(1773,'Camry',5,5,2),
(1774,'Camry (VII поколение рестайлинг)',5,NULL,NULL),
(1775,'Corolla (X поколение рестайлинг)',5,NULL,NULL),
(1776,'Corolla (XI поколение)',5,NULL,NULL),
(1777,'GT86 (I поколение)',5,NULL,NULL),
(1778,'Highlander (II поколение)',5,NULL,NULL),
(1779,'Highlander (III поколение)',5,NULL,NULL),
(1780,'iQ (I поколение)',5,NULL,NULL),
(1781,'Land Cruiser (J200)',5,NULL,NULL),
(1782,'Land Cruiser (J200 рестайлинг)',5,NULL,NULL),
(1783,'Land Cruiser Prado (J150)',5,NULL,NULL),
(1784,'Land Cruiser Prado (J150 рестайлинг)',5,NULL,NULL),
(1785,'Prius (ZVW30)',5,NULL,NULL),
(1786,'Prius (ZVW30 рестайлинг)',5,NULL,NULL),
(1787,'RAV4 (III поколение 2-й рестайлинг)',5,NULL,NULL),
(1788,'RAV4 (III поколение рестайлинг)',5,NULL,NULL),
(1789,'RAV4 (IV поколение)',5,NULL,NULL),
(1790,'Venza (I поколение рестайлинг)',5,NULL,NULL),
(1791,'Verso (I поколение)',5,NULL,NULL),
(1792,'Verso (I поколение рестайлинг)',5,NULL,NULL),
(1793,'Yaris (II поколение рестайлинг)',5,NULL,NULL),
(1794,'Yaris (III поколение)',5,NULL,NULL),
(1795,'Amarok (I поколение)',28,NULL,NULL),
(1796,'Beetle (III поколение)',28,NULL,NULL),
(1797,'CrossPolo (V поколение)',28,NULL,NULL),
(1798,'Golf (VI поколение)',28,NULL,NULL),
(1799,'Golf (VII поколение)',28,NULL,NULL),
(1800,'Golf GTI (VI поколение)',28,NULL,NULL),
(1801,'Golf GTI (VII поколение)',28,NULL,NULL),
(1802,'Golf Plus (VI поколение)',28,NULL,NULL),
(1803,'Golf R (VI поколение)',28,NULL,NULL),
(1804,'Golf R (VII поколение)',28,NULL,NULL),
(1805,'Jetta (V поколение)',28,NULL,NULL),
(1806,'Jetta (VI поколение)',28,NULL,NULL),
(1807,'Passat (B7)',28,NULL,NULL),
(1808,'Passat (B8)',28,NULL,NULL),
(1809,'Passat CC (I поколение)',28,NULL,NULL),
(1810,'Passat CC (I поколение рестайлинг)',28,NULL,NULL),
(1811,'Phaeton (I поколение)',28,NULL,NULL),
(1812,'Phaeton (I поколение рестайлинг)',28,NULL,NULL),
(1813,'Polo (V поколение)',28,NULL,NULL),
(1814,'Scirocco (III поколение)',28,NULL,NULL),
(1815,'Tiguan (I поколение)',28,NULL,NULL),
(1816,'Tiguan (I поколение рестайлинг)',28,NULL,NULL),
(1817,'Touareg (I поколение рестайлинг)',28,NULL,NULL),
(1818,'Touareg (II поколение)',28,NULL,NULL),
(1819,'Touran (II поколение)',28,NULL,NULL),
(1820,'Touran (III поколение)',28,NULL,NULL),
(1821,'C30 (I поколение рестайлинг)',2,NULL,NULL),
(1822,'C70 (II поколение рестайлинг)',2,NULL,NULL),
(1823,'S40 (II поколение)',2,NULL,NULL),
(1824,'S60 (II поколение)',2,NULL,NULL),
(1825,'S60 (II поколение рестайлинг)',2,NULL,NULL),
(1826,'S80 (II поколение)',2,NULL,NULL),
(1827,'S80 (II поколение 2-й рестайлинг)',2,NULL,NULL),
(1828,'S80 (II поколение рестайлинг)',2,NULL,NULL),
(1829,'V40 (II поколение)',2,NULL,NULL),
(1830,'V40 Cross Country (II поколение)',2,NULL,NULL),
(1831,'V50 (I поколение)',2,NULL,NULL),
(1832,'V60 (I поколение)',2,NULL,NULL),
(1833,'V60 (I поколение рестайлинг)',2,NULL,NULL),
(1834,'V70 (III поколение)',2,NULL,NULL),
(1835,'XC60 (I поколение)',2,NULL,NULL),
(1836,'XC60 (I поколение рестайлинг)',2,NULL,NULL),
(1837,'XC70 (II поколение)',2,NULL,NULL),
(1838,'XC70 (II поколение 2-й рестайлинг)',2,NULL,NULL),
(1839,'XC70 (II поколение рестайлинг)',2,NULL,NULL),
(1840,'XC90 (I поколение рестайлинг)',2,NULL,NULL),
(1841,'XC90 (II поколение)',2,NULL,NULL),
(1842,'Chance (I поколение)',92,NULL,NULL),
(1843,'Vida (I поколение)',92,NULL,NULL),
(1844,'Aquila (I поколение)',93,NULL,NULL),
(1845,'Vortex Estina (I поколение рестайлинг)',93,NULL,NULL),
(1846,'Hyundai Accent (II поколение)',93,NULL,NULL),
(1847,'Hyundai Santa Fe Classic (I поколение)',93,NULL,NULL),
(1848,'Hyundai Sonata (IV поколение)',93,NULL,NULL),
(1849,'Road Partner (I поколение)',93,NULL,NULL),
(1850,'Tager (I поколение)',93,NULL,NULL),
(1851,'Hunter (I поколение)',94,NULL,NULL),
(1852,'Patriot (I поколение)',94,NULL,NULL),
(1853,'Cayenne S Diesel (II поколение)',46,NULL,NULL),
(1854,'911 Carrera 4S (991)',46,NULL,NULL),
(1855,'SL-Класс (R231)',14,NULL,NULL),
(1856,'5 серия (E60/E61)',53,NULL,NULL),
(1857,'5 серия (E39)',53,NULL,NULL),
(1861,'Teana (J31)',57,NULL,NULL),
(1865,'SLK6142',98,NULL,NULL),
(1866,'Navigator',99,NULL,NULL),
(1868,'S-Класс (W220)',14,NULL,NULL),
(1869,'B-Класс (B180)',14,NULL,NULL),
(1870,'E-Класс',14,NULL,NULL),
(1871,'QX56 (III поколение)',40,NULL,NULL),
(1872,'307 (II поколение)',6,NULL,NULL),
(1873,'Navigator (III поколение)',101,NULL,NULL),
(1874,'Navigator (II поколение)',101,NULL,NULL),
(1875,'Navigator (I поколение)',101,NULL,NULL),
(1876,'Lite Ace Noah',5,NULL,NULL),
(1877,'Granvia',5,NULL,NULL),
(1878,'Caravelle',28,NULL,NULL),
(1879,'Eurobus E29',103,NULL,NULL),
(1880,'S228',25,NULL,NULL),
(1884,'Grand Starex Limousine',48,NULL,NULL),
(1885,'300М',39,NULL,NULL),
(1886,'LT',28,NULL,NULL),
(1887,'Avante (V поколение Elantra)',48,NULL,NULL),
(1889,'S-Класс (W140)',14,NULL,NULL),
(1891,'M-Класс (ML350)',14,NULL,NULL),
(1893,'E-Класс (W210/S210)',14,NULL,NULL),
(1895,'E-Класс (W124 Rolls-Royce)',14,NULL,NULL),
(1896,'CLK-класс (W208)',14,NULL,NULL),
(1897,'Windom (III поколение)',5,NULL,NULL),
(1899,'Estima (I поколение)',5,NULL,NULL),
(1900,'Estima (II поколение)',5,NULL,NULL),
(1903,'Sequoia (II поколение)',5,NULL,NULL),
(1904,'H-100',48,NULL,NULL),
(1905,'Jinbei Haise',69,NULL,NULL),
(1907,'Futura Magnum',105,NULL,NULL),
(1908,'Odyssey ',79,NULL,NULL),
(1909,'Galaxy',15,NULL,NULL),
(1910,'Excursion ',15,NULL,NULL),
(1911,'S317',25,NULL,NULL),
(1912,'Chorus',48,NULL,NULL),
(1913,'Camry Solara (II поколение)',5,NULL,NULL),
(1914,'309',25,NULL,NULL),
(1915,'Primera',57,NULL,NULL),
(1916,'Passat (B5)',28,NULL,NULL),
(1917,'Grand Voyager (IV поколение)',39,NULL,NULL),
(1918,'Econoline (IV поколение рестайлинг)',15,NULL,NULL),
(1919,'Econoline (IV поколение)',15,NULL,NULL),
(1920,'H1 (II поколение)',48,NULL,NULL),
(1921,'H1 (I поколение)',48,NULL,NULL),
(1922,'Delica (IV поколение)',37,NULL,NULL),
(1923,'Delica (V поколение)',37,NULL,NULL),
(1924,'Master (II поколение)',51,NULL,NULL),
(1925,'Master (II поколение рестайлинг)',51,NULL,NULL),
(1926,'Master Bus',51,NULL,NULL),
(1927,'S250',25,NULL,NULL),
(1929,'256',60,NULL,NULL),
(1930,'Land Cruiser 100',5,NULL,NULL),
(1931,'Vectra',54,NULL,NULL),
(1932,'Teamstar',14,NULL,NULL),
(1933,'O407',14,NULL,NULL),
(1934,'O408',14,NULL,NULL),
(1937,'2203',118,NULL,NULL),
(1940,'Futura',105,NULL,NULL),
(1941,'Magiq',105,NULL,NULL),
(1942,'BH090',19,NULL,NULL),
(1943,'BH113',19,NULL,NULL),
(1944,'BH115',19,NULL,NULL),
(1945,'BH116',19,NULL,NULL),
(1946,'BH117',19,NULL,NULL),
(1947,'BH119',19,NULL,NULL),
(1948,'BH120',19,NULL,NULL),
(1949,'FX116',19,NULL,NULL),
(1950,'FX120',19,NULL,NULL),
(1951,'FX212',19,NULL,NULL),
(1952,'AeroExpress',48,NULL,NULL),
(1953,'AeroQueen',48,NULL,NULL),
(1956,'County Deluxe',48,NULL,NULL),
(1958,'Crossway',102,NULL,NULL),
(1959,'Magelys',102,NULL,NULL),
(1960,'MyWay',102,NULL,NULL),
(1961,'PowerDaily',102,NULL,NULL),
(1964,'211',20,NULL,NULL),
(1965,'250',20,NULL,NULL),
(1966,'BX212 Royal Hi-Decker',19,NULL,NULL),
(1969,'Novo',9,NULL,NULL),
(1970,'Cosmos',12,NULL,NULL),
(1971,'JAC',112,NULL,NULL),
(1972,'Refine',112,NULL,NULL),
(1973,'A03 Lion\'s Star',1,NULL,NULL),
(1974,'A04 Lion\'s Comfort',1,NULL,NULL),
(1975,'R02 Lion\'s Star',1,NULL,NULL),
(1976,'R03 Lion\'s Star',1,NULL,NULL),
(1977,'R08 Lion\'s Coach',1,NULL,NULL),
(1978,'R09 Lion\'s Coach',1,NULL,NULL),
(1979,'R13 Lion\'s Regio',1,NULL,NULL),
(1980,'SR280',1,NULL,NULL),
(1981,'TransStar',14,NULL,NULL),
(1986,'O510 Tourino',14,NULL,NULL),
(1988,'O550 Integro',14,NULL,NULL),
(1989,'Sprinter 313',14,NULL,NULL),
(1990,'Sprinter 315',14,NULL,NULL),
(1991,'Sprinter 413',14,NULL,NULL),
(1992,'Sprinter 515',14,NULL,NULL),
(1993,'Sprinter 513',14,NULL,NULL),
(1994,'Sprinter 519',14,NULL,NULL),
(1996,'N1116 Cityliner',3,NULL,NULL),
(1997,'N1117 Spaceliner',3,NULL,NULL),
(1998,'N1122 Skyliner',3,NULL,NULL),
(1999,'N116 Cityliner',3,NULL,NULL),
(2000,'N1216 Cityliner',3,NULL,NULL),
(2001,'N1217 Cityliner',3,NULL,NULL),
(2003,'N1218 Cityliner',3,NULL,NULL),
(2004,'N208 Jetliner',3,NULL,NULL),
(2005,'N212 Jetliner',3,NULL,NULL),
(2007,'N213 Jetliner',3,NULL,NULL),
(2008,'N216 Jetliner',3,NULL,NULL),
(2009,'N312 Euroliner',3,NULL,NULL),
(2010,'N312 Transliner',3,NULL,NULL),
(2011,'N313 Euroliner',3,NULL,NULL),
(2012,'N314 Transliner',3,NULL,NULL),
(2014,'N316 Euroliner',3,NULL,NULL),
(2015,'N316 Transliner',3,NULL,NULL),
(2017,'N318 Transliner',3,NULL,NULL),
(2018,'N318 Euroliner',3,NULL,NULL),
(2019,'N209 Jetliner',3,NULL,NULL),
(2020,'N214 Jetliner',3,NULL,NULL),
(2022,'N321 Transliner',3,NULL,NULL),
(2023,'N3313 Euroliner',3,NULL,NULL),
(2024,'N3316 Euroliner',3,NULL,NULL),
(2025,'N3318 Euroliner',3,NULL,NULL),
(2026,'N3516 Trendliner',3,NULL,NULL),
(2027,'MD 6122',21,NULL,NULL),
(2028,'MD 6705',21,NULL,NULL),
(2030,'MD 6750',21,NULL,NULL),
(2031,'N113 Cityliner',3,NULL,NULL),
(2032,'N118 Cityliner',3,NULL,NULL),
(2037,'N424',3,NULL,NULL),
(2038,'N516 Starliner',3,NULL,NULL),
(2039,'SL 200 (Party Bus)',1,NULL,NULL),
(2040,'N426',3,NULL,NULL),
(2041,'Transporter (V поколение)',28,NULL,NULL),
(2042,'N5217 Starliner',3,NULL,NULL),
(2043,'N5218 Starliner',3,NULL,NULL),
(2045,'Irizar',18,NULL,NULL),
(2046,'OmniLine',18,NULL,NULL),
(2047,'S120',25,NULL,NULL),
(2048,'S200',25,NULL,NULL),
(2049,'S208',25,NULL,NULL),
(2050,'S214',25,NULL,NULL),
(2051,'S216',25,NULL,NULL),
(2052,'S217',25,NULL,NULL),
(2053,'S312',25,NULL,NULL),
(2054,'S316',25,NULL,NULL),
(2055,'S319',25,NULL,NULL),
(2056,'S328',25,NULL,NULL),
(2057,'S411',25,NULL,NULL),
(2059,'S415',25,NULL,NULL),
(2060,'S416',25,NULL,NULL),
(2061,'S417',25,NULL,NULL),
(2062,'S419',25,NULL,NULL),
(2063,'S431DT',25,NULL,NULL),
(2064,'S515HD',25,NULL,NULL),
(2065,'S516',25,NULL,NULL),
(2066,'S517',25,NULL,NULL),
(2067,'MD',33,NULL,NULL),
(2068,'LD',33,NULL,NULL),
(2069,'RD',33,NULL,NULL),
(2070,'Tourmalin',33,NULL,NULL),
(2072,'9700',2,NULL,NULL),
(2073,'9500',2,NULL,NULL),
(2074,'9400',2,NULL,NULL),
(2076,'6106',27,NULL,NULL),
(2077,'6126',27,NULL,NULL),
(2078,'6129 Grand Cruiser',27,NULL,NULL),
(2079,'6145',27,NULL,NULL),
(2081,'XML6602',27,NULL,NULL),
(2083,'XMQ6120C',24,NULL,NULL),
(2084,'XMQ6127C',24,NULL,NULL),
(2085,'XMQ6129Y',24,NULL,NULL),
(2086,'XMQ6800',24,NULL,NULL),
(2087,'XMQ6900',24,NULL,NULL),
(2093,'Next',7,NULL,NULL),
(2094,'5291 Круиз',62,NULL,NULL),
(2095,'5251 Вояж',62,NULL,NULL),
(2097,'5256',62,NULL,NULL),
(2098,'Валдай',10,NULL,NULL),
(2103,'6931',281,NULL,NULL),
(2104,'SLK6600',114,NULL,NULL),
(2105,'SLK6702',114,NULL,NULL),
(2106,'TATA Aria',115,NULL,NULL),
(2109,'LCK6140',99,NULL,NULL),
(2110,'Caesar LCK 6126H',99,NULL,NULL),
(2111,'Creator',99,NULL,NULL),
(2112,'Cruis',99,NULL,NULL),
(2113,'Catch',99,NULL,NULL),
(2114,'Sparkling',99,NULL,NULL),
(2115,'Triumph',99,NULL,NULL),
(2116,'Coaster LCK6752D',99,NULL,NULL),
(2117,'YCK6748',116,NULL,NULL),
(2118,'YCK6106HG A7',116,NULL,NULL),
(2119,'YCK6116HGL A7',116,NULL,NULL),
(2121,'152',60,NULL,NULL),
(2125,'231',60,NULL,NULL),
(2126,'241',60,NULL,NULL),
(2127,'251',60,NULL,NULL),
(2130,'Ритмикс-Avia',107,NULL,NULL),
(2131,'Дельфин',107,NULL,NULL),
(2132,'Дельта',107,NULL,NULL),
(2136,'А07А/А1-10',92,NULL,NULL),
(2139,'А10L50',92,NULL,NULL),
(2144,'Eos',28,NULL,NULL),
(2145,'Dion',37,NULL,NULL),
(2146,'Stepwgn ( I поколение)',79,NULL,NULL),
(2147,'Stepwgn ( II поколение ) ',79,NULL,NULL),
(2148,'Stepwgn ( III поколение)',79,NULL,NULL),
(2149,'Stepwgn ( IV поколение )',79,NULL,NULL),
(2153,'Grand Hiace',5,NULL,NULL),
(2155,'Maxus',120,NULL,NULL),
(2156,'2217 Баргузин ',7,NULL,NULL),
(2157,'Sptinter Mini (рестайлинг)',14,NULL,NULL),
(2163,'6891',11,NULL,NULL),
(2182,'4234',8,NULL,NULL),
(2185,'5277-01',123,NULL,NULL),
(2187,'42191-01',123,NULL,NULL),
(2190,'Partner Tepee',6,NULL,NULL),
(2192,'110',42,NULL,NULL),
(2195,'Corolla Spasio ( I поколение) ',5,NULL,NULL),
(2196,'Corolla Spasio ( II поколение) ',5,NULL,NULL),
(2197,'Element',79,NULL,NULL),
(2198,'Ipsum ( I поколение)',5,NULL,NULL),
(2200,'Ipsum ( II поколение)',5,NULL,NULL),
(2201,'6119',11,NULL,NULL),
(2203,'TransStar',36,NULL,NULL),
(2206,'О560',14,NULL,NULL),
(2208,'Sprinter 211',14,NULL,NULL),
(2209,'SLK6126',281,NULL,NULL),
(2210,'6899',13,NULL,NULL),
(2211,'SLK6122',281,NULL,NULL),
(2212,'6840',11,NULL,NULL),
(2213,'410',14,NULL,NULL),
(2218,'O330',14,NULL,NULL),
(2219,'Concorde (II поколение)',39,NULL,NULL),
(2220,'Concorde (I поколение)',39,NULL,NULL),
(2224,'V-класс',14,NULL,NULL),
(2225,'S-Класс (W222 рестайлинг)',14,NULL,NULL),
(2227,'S-Type',45,NULL,NULL),
(2228,'Suburban ',30,NULL,NULL),
(2231,'Viano (рестайлинг)',14,NULL,NULL),
(2232,'Midi',9,NULL,NULL),
(2234,'6798',281,NULL,NULL),
(2235,'ComPass',99,NULL,NULL),
(2238,'C-Класс AMG (W205/S205/C205)',14,NULL,NULL),
(2239,'VIANO LUX',14,NULL,NULL),
(2241,'S60 (I поколение)',2,NULL,NULL),
(2242,'Lions Regio R12',1,NULL,NULL),
(2243,'Aviator',101,NULL,NULL),
(2245,'A80',18,NULL,NULL),
(2246,'C-Класс (W202/S202)',14,NULL,NULL),
(2247,'Maxima (VII поколение)',57,NULL,NULL),
(2251,'A4 (B7)',55,NULL,NULL),
(2252,'Sienna',5,NULL,NULL),
(2253,'T815 Acron',32,NULL,NULL),
(2259,'Combi',12,NULL,NULL),
(2260,'6119',13,NULL,NULL),
(2261,'O340',14,NULL,NULL),
(2262,'B10M',2,NULL,NULL),
(2267,'S 216',25,NULL,NULL),
(2268,'S-класс (W220 рестайлинг)',14,NULL,NULL),
(2269,'516/3 Starliner',3,NULL,NULL),
(2271,'Sprinter 311',14,NULL,NULL),
(2273,'Voyager ',39,NULL,NULL),
(2274,'7 серия ( E65/Е66 )',53,NULL,NULL),
(2275,'3 (I поколение)',85,NULL,NULL),
(2276,'Almera II',57,NULL,NULL),
(2277,'Focus II',15,NULL,NULL),
(2278,'6 ( I поколение)',85,NULL,NULL),
(2279,'Accord VII',79,NULL,NULL),
(2280,'960',2,NULL,NULL),
(2281,'Windstar ( I поколение)',15,NULL,NULL),
(2282,'Windstar II поколение',15,NULL,NULL),
(2283,'0325',14,NULL,NULL),
(2285,'N117 Spaceliner',3,NULL,NULL),
(2286,'S80 ( I поколение)',2,NULL,NULL),
(2287,'GX ( I поколение )',4,NULL,NULL),
(2288,'FoxBus',102,NULL,NULL),
(2290,'Town Car',101,NULL,NULL),
(2291,'Maybach 62S',194,NULL,NULL),
(2292,'607',6,NULL,NULL),
(2294,'Berlingo',29,NULL,NULL),
(2296,'S316 HDS',25,NULL,NULL),
(2300,'Нефаз',35,NULL,NULL),
(2301,'5270',107,NULL,NULL),
(2302,'Голаз',62,NULL,NULL),
(2303,'103',60,NULL,NULL),
(2304,'Global',48,NULL,NULL),
(2305,'Urbanway',102,NULL,NULL),
(2306,'260',20,NULL,NULL),
(2307,'O405',14,NULL,NULL),
(2308,'O305',14,NULL,NULL),
(2309,'Moon God',21,NULL,NULL),
(2310,'N220 Longliner',3,NULL,NULL),
(2311,'N409',3,NULL,NULL),
(2313,'N407',3,NULL,NULL),
(2314,'N421',3,NULL,NULL),
(2315,'S412',25,NULL,NULL),
(2316,'XML6840',27,NULL,NULL),
(2317,'5292',34,NULL,NULL),
(2318,'5293',34,NULL,NULL),
(2319,'677',34,NULL,NULL),
(2320,'Ситиритм',107,NULL,NULL),
(2321,'107',60,NULL,NULL),
(2322,'203',60,NULL,NULL),
(2323,'206',60,NULL,NULL),
(2324,'226',60,NULL,NULL),
(2325,'Ритмикс',107,NULL,NULL),
(2326,'А10С30',92,NULL,NULL),
(2327,'ZK6118HGA',13,NULL,NULL),
(2328,'5277',123,NULL,NULL),
(2329,'4251',123,NULL,NULL),
(2330,'4251-01',123,NULL,NULL),
(2331,'BS211',19,NULL,NULL),
(2332,'4219/42191',123,NULL,NULL),
(2333,'A10C31',92,NULL,NULL),
(2334,'I-VAN А07А/А1',92,NULL,NULL),
(2335,'XML 6720',27,NULL,NULL),
(2336,'SL202',1,NULL,NULL),
(2337,'NM 152',1,NULL,NULL),
(2338,'MAN',1,NULL,NULL),
(2339,'Bluebird',57,NULL,NULL),
(2349,'6212 / 3',34,NULL,NULL),
(2350,'205/215',60,NULL,NULL),
(2351,'104',60,NULL,NULL),
(2352,'105',60,NULL,NULL),
(2355,'5266/52661',123,NULL,NULL),
(2356,'415',20,NULL,NULL),
(2357,'435',20,NULL,NULL),
(2358,'XML6125',27,NULL,NULL),
(2359,'5299',35,NULL,NULL),
(2360,'3299',35,NULL,NULL),
(2361,'52523/8',106,NULL,NULL),
(2362,'52081',106,NULL,NULL),
(2363,'5207',106,NULL,NULL),
(2364,'А1414 \'Лайнер-9\'',106,NULL,NULL),
(2365,'4207',106,NULL,NULL),
(2366,'396',20,NULL,NULL),
(2367,'365',20,NULL,NULL),
(2368,'280 / 3',20,NULL,NULL),
(2369,'5272',8,NULL,NULL),
(2370,'6226',62,NULL,NULL),
(2372,'5225',62,NULL,NULL),
(2373,'6228',62,NULL,NULL),
(2374,'622810',62,NULL,NULL),
(2375,'4244',62,NULL,NULL),
(2376,'Аврора 4230 ',8,NULL,NULL),
(2378,'3237',8,NULL,NULL),
(2379,'Real',48,NULL,NULL),
(2380,'5285',107,NULL,NULL),
(2381,'6270',107,NULL,NULL),
(2383,'3290',107,NULL,NULL),
(2384,'5271',107,NULL,NULL),
(2385,'YCK6849H',116,NULL,NULL),
(2386,'YCK6126',116,NULL,NULL),
(2387,'YCK6129',116,NULL,NULL),
(2388,'YCK6105',116,NULL,NULL),
(2389,'Zhong Tong',99,NULL,NULL),
(2390,'LCK6103',99,NULL,NULL),
(2391,'Городской',99,NULL,NULL),
(2392,'6852',13,NULL,NULL),
(2393,'6737',13,NULL,NULL),
(2394,'6121',13,NULL,NULL),
(2395,'Yutong',13,NULL,NULL),
(2397,'T8 Alizee 3**',32,NULL,NULL),
(2398,'Van Hool',32,NULL,NULL),
(2401,'T915 Acron',32,NULL,NULL),
(2402,'Opalin',33,NULL,NULL),
(2403,'SLK6108',281,NULL,NULL),
(2404,'SLK6101',114,NULL,NULL),
(2405,'S210/11/13',25,NULL,NULL),
(2406,'CN 112/3',18,NULL,NULL),
(2407,'CK95UB',18,NULL,NULL),
(2408,'CL94UB',18,NULL,NULL),
(2409,'M2*',103,NULL,NULL),
(2410,'N416',3,NULL,NULL),
(2411,'N4416 Centroliner',3,NULL,NULL),
(2412,'N401*',3,NULL,NULL),
(2413,'N117',3,NULL,NULL),
(2414,'O345',14,NULL,NULL),
(2415,'O530',14,NULL,NULL),
(2416,'025',52,NULL,NULL),
(2418,'SL 200',1,NULL,NULL),
(2419,'XMQ6121',24,NULL,NULL),
(2420,'BC/BS',19,NULL,NULL),
(2421,'BM090',19,NULL,NULL),
(2422,'Lestar',19,NULL,NULL),
(2423,'XML6***',27,NULL,NULL),
(2424,'6121',27,NULL,NULL),
(2425,'6796',27,NULL,NULL),
(2426,'6896/6957',27,NULL,NULL),
(2427,'TurboDaily',102,NULL,NULL),
(2428,'Grace',48,NULL,NULL),
(2429,'Hyundai',48,NULL,NULL),
(2430,'Higer',11,NULL,NULL),
(2431,'RB 520',48,NULL,NULL),
(2432,'KIA',12,NULL,NULL),
(2433,'AM928/937',12,NULL,NULL),
(2434,'Besta',12,NULL,NULL),
(2435,'Pregio',12,NULL,NULL),
(2436,'6720',11,NULL,NULL),
(2437,'68**',11,NULL,NULL),
(2438,'6928',11,NULL,NULL),
(2441,'A80',11,NULL,NULL),
(2442,'KLQ6118',11,NULL,NULL),
(2443,'KLQ6891',11,NULL,NULL),
(2445,'A10/12',1,NULL,NULL),
(2446,'A20 NU**3',1,NULL,NULL),
(2447,'A21 NL**3',1,NULL,NULL),
(2448,'A26 NL313-15',1,NULL,NULL),
(2449,'SG292',1,NULL,NULL),
(2450,'SG242',1,NULL,NULL),
(2451,'A78 Lion\'s City',1,NULL,NULL),
(2452,'A74 Lion\'s Classic',1,NULL,NULL),
(2453,'A32 Lion\'s Top',1,NULL,NULL),
(2454,'292',1,NULL,NULL),
(2455,'362FRH',1,NULL,NULL),
(2456,'A72 Lion\'s Classic',1,NULL,NULL),
(2458,'FRH362/SR240',1,NULL,NULL),
(2459,'R14 Lion\'s Regio',1,NULL,NULL),
(2464,'Vario',14,NULL,NULL),
(2465,'Neman (420224-511)',102,NULL,NULL),
(2467,'YTK 6126',196,NULL,NULL),
(2471,'Iliade',51,NULL,NULL),
(2472,'Escalade Express',44,NULL,NULL),
(2473,'О345',14,NULL,NULL),
(2474,'Berkhof',52,NULL,NULL),
(2475,'Civilian',57,NULL,NULL),
(2476,'Панорамик',113,NULL,NULL),
(2477,'Savana ',197,NULL,NULL),
(2478,'InterUrbino',198,NULL,NULL),
(2479,'6127',27,NULL,NULL),
(2481,'6108',13,NULL,NULL),
(2482,'6118',13,NULL,NULL),
(2485,'Omni Express LK310',18,NULL,NULL),
(2487,'4235 Аврора',10,NULL,NULL),
(2488,'4239',10,NULL,NULL),
(2495,'Sprinter 316',14,NULL,NULL),
(2496,'Andare',199,NULL,NULL),
(2497,'T-4',28,NULL,NULL),
(2499,'Istana (12 мест)',36,NULL,NULL),
(2500,'Carnival',12,NULL,NULL),
(2501,'C8',29,NULL,NULL),
(2502,'Transit (короткий)',15,NULL,NULL),
(2503,'Connect',15,NULL,NULL),
(2506,'МАЗ 103',60,NULL,NULL),
(2507,'МАЗ-206',60,NULL,NULL),
(2508,'NG 272',1,NULL,NULL),
(2509,'6102',27,NULL,NULL),
(2510,'280',20,NULL,NULL),
(2511,'S 319',25,NULL,NULL),
(2512,'5299-37',35,NULL,NULL),
(2514,'T816',32,NULL,NULL),
(2515,'T916/T917 Astron',32,NULL,NULL),
(2516,'Town Country (VII поколение)',39,NULL,NULL),
(2517,'Caddy (III поколение)',28,NULL,NULL),
(2518,'B12B Sunsundeguis',2,NULL,NULL),
(2519,'SB3000',52,NULL,NULL),
(2521,'Smit',52,NULL,NULL),
(2522,'90',200,NULL,NULL),
(2523,'260',201,NULL,NULL),
(2524,'MD 6740',21,NULL,NULL),
(2525,'LAG',113,NULL,NULL),
(2526,'Mistral',1,NULL,NULL),
(2527,'Unker Mictral',52,NULL,NULL),
(2528,'Mini Marcopolo',199,NULL,NULL),
(2529,'Mago 2',14,NULL,NULL),
(2534,'Asia AM815A Combi',12,NULL,NULL),
(2535,'Drogmoller E330H EuroComet',2,NULL,NULL),
(2536,'Aero 600',48,NULL,NULL),
(2537,'ЧАЗ-3223',140,NULL,NULL),
(2538,'UzOtoyol M29.12',103,NULL,NULL),
(2546,'6109',11,NULL,NULL),
(2550,'Bogdan',9,NULL,NULL),
(2551,'Bogdan',48,NULL,NULL),
(2552,'Mini',13,NULL,NULL),
(2557,'S228 DT',25,NULL,NULL),
(2559,'LCK 6127 h',99,NULL,NULL),
(2560,'Viaggio II 370',199,NULL,NULL),
(2561,'9900',2,NULL,NULL),
(2563,'3976',10,NULL,NULL),
(2564,'3275(6)',10,NULL,NULL),
(2566,'3244',10,NULL,NULL),
(2568,'4242',62,NULL,NULL),
(2569,'52991',35,NULL,NULL),
(2570,'T91*/3',32,NULL,NULL),
(2573,'SG',25,NULL,NULL),
(2574,'KLQ6608',11,NULL,NULL),
(2578,'5256.',34,NULL,NULL),
(2579,'4216',203,NULL,NULL),
(2580,'А079',204,NULL,NULL),
(2581,'4252',205,NULL,NULL),
(2582,'Г1х1',206,NULL,NULL),
(2583,'42021',106,NULL,NULL),
(2584,'525110',34,NULL,NULL),
(2585,'4201',117,NULL,NULL),
(2586,'5236',207,NULL,NULL),
(2587,'3230',208,NULL,NULL),
(2589,'2221',7,NULL,NULL),
(2590,'YCK6602',116,NULL,NULL),
(2591,'6122',13,NULL,NULL),
(2592,'6126',13,NULL,NULL),
(2595,'YouYi',210,NULL,NULL),
(2596,'6705',211,NULL,NULL),
(2597,'JNP61379-1E',212,NULL,NULL),
(2598,'JNP6126',212,NULL,NULL),
(2599,'4298',213,NULL,NULL),
(2600,'5270',213,NULL,NULL),
(2602,'6271',213,NULL,NULL),
(2603,'4239.',10,NULL,NULL),
(2604,'6233',214,NULL,NULL),
(2605,'163 туалет',60,NULL,NULL),
(2606,'6208',215,NULL,NULL),
(2607,'5000',217,NULL,NULL),
(2608,'5000E',217,NULL,NULL),
(2609,'8000',217,NULL,NULL),
(2610,'2245 street',63,NULL,NULL),
(2611,'BJ6830',218,NULL,NULL),
(2612,'Aabenraa',216,NULL,NULL),
(2614,'B10BLE-60',2,NULL,NULL),
(2615,'B10M-60',2,NULL,NULL),
(2618,'System 2000NL',216,NULL,NULL),
(2619,'City',217,NULL,NULL),
(2620,'Classic II 340',217,NULL,NULL),
(2621,'Express',217,NULL,NULL),
(2623,'Feniks',102,NULL,NULL),
(2624,'Royal',217,NULL,NULL),
(2625,'Royal Gods',217,NULL,NULL),
(2626,'Vector',217,NULL,NULL),
(2627,'Victor',217,NULL,NULL),
(2628,'Inter Regio',2,NULL,NULL),
(2629,'МD27A/S',219,NULL,NULL),
(2630,'MD22 Urban',219,NULL,NULL),
(2631,'Viana',220,NULL,NULL),
(2632,'6000',217,NULL,NULL),
(2633,'6000 Apollo',217,NULL,NULL),
(2634,'6000 Jaspis',217,NULL,NULL),
(2635,'AM938AT/939',12,NULL,NULL),
(2636,'Apollo',222,NULL,NULL),
(2637,'H10-11',108,NULL,NULL),
(2638,'H10-11.11B',108,NULL,NULL),
(2639,'H10-12.16 Inter',108,NULL,NULL),
(2640,'H9',108,NULL,NULL),
(2642,'H9-21',108,NULL,NULL),
(2644,'AM 362H',234,NULL,NULL),
(2645,'Apolo II',224,NULL,NULL),
(2646,'Atlantis',224,NULL,NULL),
(2647,'Atlas',224,NULL,NULL),
(2648,'Bravo I',224,NULL,NULL),
(2650,'Olimpia',224,NULL,NULL),
(2652,'Olimpo-B',224,NULL,NULL),
(2654,'C2',225,NULL,NULL),
(2655,'Italia 99 I.a ed.',225,NULL,NULL),
(2656,'Axial 100',226,NULL,NULL),
(2657,'Axial 50',226,NULL,NULL),
(2658,'Axial 70',226,NULL,NULL),
(2659,'Esprite',226,NULL,NULL),
(2660,'Europa 2000 Duvedec',226,NULL,NULL),
(2661,'Europa 2000A Duvedec',226,NULL,NULL),
(2662,'Europa 2000NL',226,NULL,NULL),
(2663,'Everest',226,NULL,NULL),
(2664,'Excellence 1000',226,NULL,NULL),
(2665,'Excellence 1000 Midi',226,NULL,NULL),
(2666,'Excellence 2000',226,NULL,NULL),
(2668,'Excellence 2000HD',226,NULL,NULL),
(2669,'Excellence 2000HL',226,NULL,NULL),
(2670,'Excellence 3000',226,NULL,NULL),
(2671,'Excellence 3000HD',226,NULL,NULL),
(2672,'Excellence 3000HLE',226,NULL,NULL),
(2673,'Standaard 2000',226,NULL,NULL),
(2674,'Stergo',227,NULL,NULL),
(2676,'International',229,NULL,NULL),
(2677,'CSRE 3204',229,NULL,NULL),
(2678,'Q Bus',229,NULL,NULL),
(2679,'Vision',229,NULL,NULL),
(2680,'AP160',231,NULL,NULL),
(2681,'Thesi',231,NULL,NULL),
(2683,'Beta II',232,NULL,NULL),
(2685,'Optimo IV',232,NULL,NULL),
(2687,'Super Beta 4000',232,NULL,NULL),
(2688,'Canelas 350',235,NULL,NULL),
(2689,'Cometa',235,NULL,NULL),
(2690,'Riviera',235,NULL,NULL),
(2691,'Classic',236,NULL,NULL),
(2692,'Fifty',236,NULL,NULL),
(2694,'Regal',236,NULL,NULL),
(2695,'Regal 350',236,NULL,NULL),
(2697,'Star 202',236,NULL,NULL),
(2698,'Star 301',236,NULL,NULL),
(2699,'Star 302',236,NULL,NULL),
(2700,'Star 502',236,NULL,NULL),
(2701,'Star 602',236,NULL,NULL),
(2702,'Star 701',236,NULL,NULL),
(2703,'Superstar',236,NULL,NULL),
(2704,'Vector',236,NULL,NULL),
(2705,'Vega/VegaL',236,NULL,NULL),
(2706,'Bolero',237,NULL,NULL),
(2707,'2400',238,NULL,NULL),
(2709,'2700S',238,NULL,NULL),
(2710,'3000',238,NULL,NULL),
(2711,'1350L',239,NULL,NULL),
(2712,'Citybus (15-1200C)',239,NULL,NULL),
(2713,'BF106',19,NULL,NULL),
(2714,'BV113',19,NULL,NULL),
(2716,'De Simon',240,NULL,NULL),
(2717,'100',241,NULL,NULL),
(2718,'200',241,NULL,NULL),
(2719,'300',241,NULL,NULL),
(2720,'400',241,NULL,NULL),
(2721,'500',241,NULL,NULL),
(2722,'City S',241,NULL,NULL),
(2723,'Express',241,NULL,NULL),
(2725,'Mini-Star',241,NULL,NULL),
(2726,'Star',241,NULL,NULL),
(2727,'Star 301',241,NULL,NULL),
(2730,'Star 501',241,NULL,NULL),
(2731,'Superstar',241,NULL,NULL),
(2732,'Superstar 9000',241,NULL,NULL),
(2733,'MB200',52,NULL,NULL),
(2735,'SB220',52,NULL,NULL),
(2736,'LOB',242,NULL,NULL),
(2737,'DFA6600',126,NULL,NULL),
(2738,'DFA6720',126,NULL,NULL),
(2739,'DFA6720KB02',126,NULL,NULL),
(2740,'DFA6720KB02A',126,NULL,NULL),
(2741,'DFA6801',126,NULL,NULL),
(2742,'22.372 SHD',1,NULL,NULL),
(2743,'E280 SuperPullman',243,NULL,NULL),
(2744,'E310 SuperPullman',243,NULL,NULL),
(2745,'E325 EuroPullman',243,NULL,NULL),
(2746,'E330H EuroComet',243,NULL,NULL),
(2747,'E430 SuperComet',243,NULL,NULL),
(2748,'E430U SuperComet',243,NULL,NULL),
(2749,'Gera Euroskate',245,NULL,NULL),
(2750,'Gera MidiSkate',245,NULL,NULL),
(2751,'100',200,NULL,NULL),
(2752,'233',200,NULL,NULL),
(2753,'90 (EOS)',200,NULL,NULL),
(2754,'Clubstar',246,NULL,NULL),
(2757,'Panorama',246,NULL,NULL),
(2758,'Teamstar',246,NULL,NULL),
(2760,'Teamstar Kombi',246,NULL,NULL),
(2762,'Grand Tourismo',247,NULL,NULL),
(2764,'Transpol',247,NULL,NULL),
(2766,'NM223',1,NULL,NULL),
(2768,'SG192',1,NULL,NULL),
(2770,'SM182',1,NULL,NULL),
(2771,'O402',14,NULL,NULL),
(2773,'GSGU280 M18',250,NULL,NULL),
(2774,'GSUH240 M12',250,NULL,NULL),
(2775,'GSUH290 M12',250,NULL,NULL),
(2776,'NL222',1,NULL,NULL),
(2777,'Cobra GL9',251,NULL,NULL),
(2778,'111',252,NULL,NULL),
(2779,'Rainbow RB',182,NULL,NULL),
(2780,'SFQ6115JSLK',182,NULL,NULL),
(2781,'Avutarda',254,NULL,NULL),
(2782,'Vita',254,NULL,NULL),
(2783,'DD6125K01',255,NULL,NULL),
(2784,'DD6861S05',255,NULL,NULL),
(2785,'AC6650KJ',256,NULL,NULL),
(2787,'IK-104P',257,NULL,NULL),
(2789,'IK-201',257,NULL,NULL),
(2790,'IK-202',257,NULL,NULL),
(2791,'IK-206',257,NULL,NULL),
(2792,'IK-218NC',257,NULL,NULL),
(2794,'IK-301',257,NULL,NULL),
(2795,'IK-308',257,NULL,NULL),
(2796,'396.42',20,NULL,NULL),
(2797,'396.67',20,NULL,NULL),
(2798,'543',20,NULL,NULL),
(2799,'545',20,NULL,NULL),
(2800,'664',20,NULL,NULL),
(2801,'C56.22',20,NULL,NULL),
(2802,'EAG E14',20,NULL,NULL),
(2803,'E98HD/398HD',20,NULL,NULL),
(2806,'Mago 2',258,NULL,NULL),
(2808,'Wing',258,NULL,NULL),
(2809,'O309D',14,NULL,NULL),
(2810,'O355',14,NULL,NULL),
(2811,'O457',14,NULL,NULL),
(2812,'Arway 12M',259,NULL,NULL),
(2813,'Evadys',259,NULL,NULL),
(2814,'Evadys H 12M',259,NULL,NULL),
(2815,'Century',260,NULL,NULL),
(2816,'Century 12.35',260,NULL,NULL),
(2817,'Century III',260,NULL,NULL),
(2818,'Century III 12.35',260,NULL,NULL),
(2819,'Dragon',260,NULL,NULL),
(2820,'Everest',260,NULL,NULL),
(2821,'i6 15-3,7',260,NULL,NULL),
(2822,'PB 12-3,5',260,NULL,NULL),
(2823,'PB 14-3,7',260,NULL,NULL),
(2824,'Turkuaz',9,NULL,NULL),
(2826,'HK6730K',112,NULL,NULL),
(2827,'120М',261,NULL,NULL),
(2828,'M11',261,NULL,NULL),
(2829,'PR110D',261,NULL,NULL),
(2830,'T120',261,NULL,NULL),
(2831,'Arrow',262,NULL,NULL),
(2832,'City 041',262,NULL,NULL),
(2833,'Deauville 35',262,NULL,NULL),
(2834,'Deauville 45',262,NULL,NULL),
(2835,'Deauville 65',262,NULL,NULL),
(2836,'Deauville TopDeck',262,NULL,NULL),
(2837,'Jubilee P35',262,NULL,NULL),
(2838,'Jubilee P799',262,NULL,NULL),
(2840,'Mistral 50',262,NULL,NULL),
(2841,'Modulo',262,NULL,NULL),
(2842,'Monaco',262,NULL,NULL),
(2843,'Trans City',262,NULL,NULL),
(2844,'Transit',262,NULL,NULL),
(2851,'B732',263,NULL,NULL),
(2852,'B741.1916',263,NULL,NULL),
(2853,'B932E.1680',263,NULL,NULL),
(2854,'C734',263,NULL,NULL),
(2855,'C934E.1351',263,NULL,NULL),
(2856,'C956.1074 Axer 12M',263,NULL,NULL),
(2857,'LC736',263,NULL,NULL),
(2858,'LC757.1060 HD 12',263,NULL,NULL),
(2859,'LC936.1037',263,NULL,NULL),
(2860,'LC936E.1038',263,NULL,NULL),
(2861,'LC956.1072',263,NULL,NULL),
(2862,'SB230',52,NULL,NULL),
(2863,'KM928',12,NULL,NULL),
(2864,'XMQ6118G',24,NULL,NULL),
(2865,'XMQ 6118 G',24,NULL,NULL),
(2866,'XMQ6121G',24,NULL,NULL),
(2867,'XMQ6840HB1',24,NULL,NULL),
(2868,'Credo IC 11',264,NULL,NULL),
(2869,'Credo LC 9.5',264,NULL,NULL),
(2871,'9',265,NULL,NULL),
(2872,'9S',265,NULL,NULL),
(2873,'9SS',265,NULL,NULL),
(2874,'Deca 320',265,NULL,NULL),
(2875,'Deca 360',265,NULL,NULL),
(2876,'AI300',113,NULL,NULL),
(2877,'Galaxy',113,NULL,NULL),
(2878,'11',266,NULL,NULL),
(2879,'20',266,NULL,NULL),
(2880,'30',266,NULL,NULL),
(2881,'300',266,NULL,NULL),
(2882,'311',266,NULL,NULL),
(2883,'320',266,NULL,NULL),
(2884,'400',266,NULL,NULL),
(2885,'430 Falcon',266,NULL,NULL),
(2886,'431 Falcon',266,NULL,NULL),
(2887,'450 Eagle',266,NULL,NULL),
(2888,'520 Flyer',266,NULL,NULL),
(2889,'Lauber',267,NULL,NULL),
(2890,'400',52,NULL,NULL),
(2891,'LF6592',82,NULL,NULL),
(2892,'Magirus-Deutz',268,NULL,NULL),
(2893,'M 2000 R 119',268,NULL,NULL),
(2894,'R81',268,NULL,NULL),
(2895,'TR120',268,NULL,NULL),
(2896,'A01 Lion\'s Comfort UL**3',1,NULL,NULL),
(2897,'A01 Lion\'s Comfort UL353',1,NULL,NULL),
(2898,'A23 Lion\'s City GL NG363',1,NULL,NULL),
(2899,'A23 NG313',1,NULL,NULL),
(2900,'A25 NU 313-15',1,NULL,NULL),
(2901,'RU240',1,NULL,NULL),
(2902,'S2000 Mega',1,NULL,NULL),
(2903,'SD200',1,NULL,NULL),
(2904,'SG240H',1,NULL,NULL),
(2905,'SG312',1,NULL,NULL),
(2906,'SL222 MANAS',1,NULL,NULL),
(2907,'SR321H',1,NULL,NULL),
(2908,'SU240',1,NULL,NULL),
(2909,'UL242',1,NULL,NULL),
(2910,'B4 080',269,NULL,NULL),
(2911,'Marcopolo',199,NULL,NULL),
(2912,'BRAVIS',199,NULL,NULL),
(2913,'Viaggio',199,NULL,NULL),
(2914,'Viaggio I 370',199,NULL,NULL),
(2915,'Viaggio II 330',199,NULL,NULL),
(2916,'SL',270,NULL,NULL),
(2918,'100D',14,NULL,NULL),
(2920,'Turk O345G',14,NULL,NULL),
(2921,'Turk O345U',14,NULL,NULL),
(2922,'Aero KC-MJ218F',37,NULL,NULL),
(2923,'Mitsubishi Fuso',37,NULL,NULL),
(2925,'MD6825FDJ1',21,NULL,NULL),
(2927,'Domino 2001HDH',119,NULL,NULL),
(2929,'Noge Sprinter',119,NULL,NULL),
(2930,'Touring Star',119,NULL,NULL),
(2931,'Vesubio',119,NULL,NULL),
(2932,'Xaloc',119,NULL,NULL),
(2933,'S.Agaro Wind 360',271,NULL,NULL),
(2934,'ST/375',271,NULL,NULL),
(2935,'ST/400',271,NULL,NULL),
(2937,'Movano',54,NULL,NULL),
(2938,'EuroClass HD',272,NULL,NULL),
(2939,'Poker',272,NULL,NULL),
(2940,'TopClass',272,NULL,NULL),
(2941,'M-2010',273,NULL,NULL),
(2942,'Vectio 240S',273,NULL,NULL),
(2943,'E27.14',103,NULL,NULL),
(2945,'RM',274,NULL,NULL),
(2947,'FR1 GTX',51,NULL,NULL),
(2948,'PR100.2',51,NULL,NULL),
(2949,'NL2000',277,NULL,NULL),
(2950,'2000',277,NULL,NULL),
(2951,'5000',277,NULL,NULL),
(2952,'S218',276,NULL,NULL),
(2953,'S314',276,NULL,NULL),
(2954,'S315',276,NULL,NULL),
(2955,'S315TVV/VO',276,NULL,NULL),
(2956,'S415',276,NULL,NULL),
(2957,'CK112CL',18,NULL,NULL),
(2958,'CK113CLB',18,NULL,NULL),
(2959,'CR112',18,NULL,NULL),
(2960,'CR112CL',18,NULL,NULL),
(2961,'OmniCity CN94UB',18,NULL,NULL),
(2962,'SLG6600CN',278,NULL,NULL),
(2963,'SLG6660CGE',278,NULL,NULL),
(2964,'SLG6751',278,NULL,NULL),
(2965,'SLG6792CF',278,NULL,NULL),
(2966,'SLG6821CGF',278,NULL,NULL),
(2967,'YTK6103G',196,NULL,NULL),
(2968,'YTK6106',196,NULL,NULL),
(2970,'YTK6890',196,NULL,NULL),
(2971,'Euroliner',52,NULL,NULL),
(2972,'Orion',52,NULL,NULL),
(2973,'LC 10.5 Arktika',279,NULL,NULL),
(2974,'LC 9.5',279,NULL,NULL),
(2976,'SL11 HUA280',280,NULL,NULL),
(2978,'SLK6128F5AW',281,NULL,NULL),
(2981,'Stylo',282,NULL,NULL),
(2982,'Vardino',282,NULL,NULL),
(2983,'190A110T',201,NULL,NULL),
(2984,'222A110',201,NULL,NULL),
(2985,'Diamond 13',33,NULL,NULL),
(2986,'Liberty BG824E',33,NULL,NULL),
(2987,'Prestij',33,NULL,NULL),
(2988,'Safir',33,NULL,NULL),
(2989,'Conventional',284,NULL,NULL),
(2990,'Saf-T-Liner HDX',284,NULL,NULL),
(2991,'Easymaxi',285,NULL,NULL),
(2992,'Medio',285,NULL,NULL),
(2993,'Urbis 2.5DD',2,NULL,NULL),
(2995,'Granade',18,NULL,NULL),
(2996,'M23.12',103,NULL,NULL),
(2997,'M29.12',103,NULL,NULL),
(2999,'A120',32,NULL,NULL),
(3000,'A120P',32,NULL,NULL),
(3001,'A600',32,NULL,NULL),
(3002,'T8 Astrobel',32,NULL,NULL),
(3003,'M50',295,NULL,NULL),
(3004,'M600',295,NULL,NULL),
(3005,'M600H-Ekspress',295,NULL,NULL),
(3006,'4',286,NULL,NULL),
(3007,'Ambassador',286,NULL,NULL),
(3008,'Ambassador 335',286,NULL,NULL),
(3009,'Ambassador 370 Gods',286,NULL,NULL),
(3010,'Liner 320',286,NULL,NULL),
(3011,'V10',286,NULL,NULL),
(3012,'16SH',287,NULL,NULL),
(3013,'C10',288,NULL,NULL),
(3014,'T5 Kasten',28,NULL,NULL),
(3015,'7700A',2,NULL,NULL),
(3016,'8500LE',2,NULL,NULL),
(3017,'8500LEA',2,NULL,NULL),
(3020,'K100',289,NULL,NULL),
(3021,'K200',289,NULL,NULL),
(3022,'K202',289,NULL,NULL),
(3023,'M100',289,NULL,NULL),
(3024,'M300',289,NULL,NULL),
(3025,'M301',289,NULL,NULL),
(3026,'M302',289,NULL,NULL),
(3027,'M310 Combi',289,NULL,NULL),
(3028,'M500 Finlandia',289,NULL,NULL),
(3029,'M68',289,NULL,NULL),
(3030,'N200',289,NULL,NULL),
(3031,'SunLong',281,NULL,NULL),
(3032,'T2 general',14,NULL,NULL),
(3033,'XMQ6118Y',24,NULL,NULL),
(3036,'HQG6601D',296,NULL,NULL),
(3037,'Berkhof general',226,NULL,NULL),
(3038,'Vetter general',287,NULL,NULL),
(3039,'Noge general',119,NULL,NULL),
(3041,'E450 Cutaway',15,NULL,NULL),
(3044,'Go4City',298,NULL,NULL),
(3045,'B10MA',2,NULL,NULL),
(3046,'Grinder',292,NULL,NULL),
(3047,'CX-Elite',291,NULL,NULL),
(3048,'Finnliner 350',300,NULL,NULL),
(3049,'Finnliner 370',300,NULL,NULL),
(3050,'General',9,NULL,NULL),
(3052,'4292.60',34,NULL,NULL),
(3053,'529115',34,NULL,NULL),
(3059,'HK6120',112,NULL,NULL),
(3060,'Caravan',73,NULL,NULL),
(3061,'Saffle',2,NULL,NULL),
(3062,'Vivaro',54,NULL,NULL),
(3064,'Jumpy',29,NULL,NULL),
(3066,'Primastar',57,NULL,NULL),
(3067,'Nexia',19,NULL,NULL),
(3069,'Bongo',85,NULL,NULL),
(3070,'Vanette',57,NULL,NULL),
(3071,'6115',11,NULL,NULL),
(3073,'Jonckheere',1,NULL,NULL),
(3074,'SLK6126F1A',114,NULL,NULL),
(3077,'N2216SHD Tourliner',3,NULL,NULL),
(3078,'Neoplan N2216/3SHDL Tourliner',3,NULL,NULL),
(3080,'4298.01',213,NULL,NULL),
(3081,'LCK6605DK-1',99,NULL,NULL),
(3082,'Granbird Parkway',12,NULL,NULL),
(3087,'452/3741',94,NULL,NULL),
(3088,'3255',181,NULL,NULL),
(3089,'Largus',42,NULL,NULL),
(3091,'ZK6852HG',13,NULL,NULL),
(3092,'ЗИЛ-325000 (Бычок)',140,NULL,NULL),
(3096,'Staco Dexon',1,NULL,NULL),
(3098,'11.220/13.230 HOCL',1,NULL,NULL),
(3099,'Sprinter 411 CDI',14,NULL,NULL),
(3104,'Sprinter 208/13, 314',14,NULL,NULL),
(3105,'672',8,NULL,NULL),
(3126,'123 (тест)',5,NULL,NULL),
(3127,'Century 9.32',260,NULL,NULL),
(3132,'B1000 KB',301,NULL,NULL),
(3138,'EvoBus 500',14,NULL,NULL),
(3140,'Volvo',2,NULL,NULL),
(3142,'Vario 814 D',14,NULL,NULL),
(3144,'Vario 816 D',14,NULL,NULL),
(3145,'EOS 200',32,NULL,NULL),
(3146,'Sprinter 516',14,NULL,NULL),
(3147,'Sprinter 516 CDI',14,NULL,NULL),
(3149,'S 515 HD',25,NULL,NULL),
(3150,'Tracer',51,NULL,NULL),
(3152,'Visigo	',9,NULL,NULL),
(3153,'Turquoise',9,NULL,NULL),
(3154,'Sprinter 416 CDI',14,NULL,NULL),
(3155,'316 SHD',3,NULL,NULL),
(3156,'vario 815 D',14,NULL,NULL),
(3157,'Sprinter 518 CDI',14,NULL,NULL),
(3158,'S215 UL',25,NULL,NULL),
(3160,'S315 HDH/2',25,NULL,NULL),
(3161,'Sprinter 319 CDI',14,NULL,NULL),
(3162,'818',14,NULL,NULL),
(3163,'Eurobus',102,NULL,NULL),
(3164,'A404T',108,NULL,NULL),
(3167,'ProAce Family',5,NULL,NULL),
(3168,'Neobus',102,NULL,NULL),
(3169,'200',200,NULL,NULL),
(3170,'MAGO',102,NULL,NULL),
(3171,'Medio',14,NULL,NULL),
(3172,'N2216 SHD',3,NULL,NULL),
(3173,'PONTICELLI',51,NULL,NULL),
(3174,'Carrier PC 31S',51,NULL,NULL),
(3175,'Benz 223212',14,NULL,NULL),
(3177,'A0808T',108,NULL,NULL),
(3178,'Vacanza ',198,NULL,NULL),
(3179,'Irizar PB',102,NULL,NULL),
(3180,'Iliade ',259,NULL,NULL),
(3326,'E-HS9',308,NULL,NULL),
(3327,'G80',309,NULL,NULL),
(3328,'Preface',76,NULL,NULL),
(3329,'H9',308,NULL,NULL),
(3330,'Besturn',74,NULL,NULL),
(3331,'Bestune',74,5,NULL),
(3332,'Maybach',14,5,3);
/*!40000 ALTER TABLE `TransportModels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Transports`
--

DROP TABLE IF EXISTS `Transports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Transports` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `RequestId` int(11) DEFAULT NULL,
  `GovNumber` varchar(255) NOT NULL,
  `TransportManufacturerId` int(11) DEFAULT NULL,
  `TransportModelId` int(11) DEFAULT NULL,
  `HtmlColorId` int(11) DEFAULT NULL,
  `SubjectId` int(11) DEFAULT NULL,
  `Functional` longtext NOT NULL,
  `IsGovNumberNonStandard` tinyint(1) NOT NULL DEFAULT 0,
  `Photos` longtext NOT NULL,
  `Approved` tinyint(1) NOT NULL DEFAULT 1,
  `TypePassId` int(11) DEFAULT NULL,
  `RecipientName` longtext NOT NULL,
  `Issued` tinyint(1) NOT NULL DEFAULT 0,
  `IssuedById` int(11) DEFAULT NULL,
  `IssuedOn` datetime(6) DEFAULT NULL,
  `ReissueId` int(11) DEFAULT NULL,
  `ApprovedOn` datetime(6) DEFAULT NULL,
  PRIMARY KEY (`Id`),
  UNIQUE KEY `IX_Transports_GovNumber` (`GovNumber`),
  KEY `IX_Transports_HtmlColorId` (`HtmlColorId`),
  KEY `IX_Transports_RequestId` (`RequestId`),
  KEY `IX_Transports_SubjectId` (`SubjectId`),
  KEY `IX_Transports_TransportManufacturerId` (`TransportManufacturerId`),
  KEY `IX_Transports_TransportModelId` (`TransportModelId`),
  KEY `IX_Transports_TypePassId` (`TypePassId`),
  KEY `IX_Transports_IssuedById` (`IssuedById`),
  CONSTRAINT `FK_Transports_AspNetUsers_IssuedById` FOREIGN KEY (`IssuedById`) REFERENCES `AspNetUsers` (`Id`),
  CONSTRAINT `FK_Transports_HtmlColors_HtmlColorId` FOREIGN KEY (`HtmlColorId`) REFERENCES `HtmlColors` (`Id`),
  CONSTRAINT `FK_Transports_Requests_RequestId` FOREIGN KEY (`RequestId`) REFERENCES `Requests` (`Id`),
  CONSTRAINT `FK_Transports_Subjects_SubjectId` FOREIGN KEY (`SubjectId`) REFERENCES `Subjects` (`Id`),
  CONSTRAINT `FK_Transports_TransportManufacturers_TransportManufacturerId` FOREIGN KEY (`TransportManufacturerId`) REFERENCES `TransportManufacturers` (`Id`),
  CONSTRAINT `FK_Transports_TransportModels_TransportModelId` FOREIGN KEY (`TransportModelId`) REFERENCES `TransportModels` (`Id`),
  CONSTRAINT `FK_Transports_TypePasses_TypePassId` FOREIGN KEY (`TypePassId`) REFERENCES `TypePasses` (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Transports`
--

LOCK TABLES `Transports` WRITE;
/*!40000 ALTER TABLE `Transports` DISABLE KEYS */;
/*!40000 ALTER TABLE `Transports` ENABLE KEYS */;
UNLOCK TABLES;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`accreditation_user`@`10.100.100.149`*/ /*!50003 trigger Transports_Quota_Trigger after insert on Transports
for each row 
begin
         	declare quota_on_pass int;
         	declare initiator int;
            				set initiator = (select Requests.InitiatorId from Requests where new.RequestId = Requests.Id limit 1);
         	set quota_on_pass = (select Quotas.Id from Quotas where new.TypePassId = Quotas.TypePassId and Quotas.CountTransports > Quotas.UsedCountTransports and Quotas.InitiatorId = initiator limit 1);
         	
            				if quota_on_pass is not null and initiator is not null and new.ReissueId is null
            				then update Quotas set Quotas.UsedCountTransports = Quotas.UsedCountTransports + 1 where Quotas.Id = quota_on_pass;
            				end if;
end */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;
/*!50003 SET @saved_cs_client      = @@character_set_client */ ;
/*!50003 SET @saved_cs_results     = @@character_set_results */ ;
/*!50003 SET @saved_col_connection = @@collation_connection */ ;
/*!50003 SET character_set_client  = utf8mb4 */ ;
/*!50003 SET character_set_results = utf8mb4 */ ;
/*!50003 SET collation_connection  = utf8mb4_general_ci */ ;
/*!50003 SET @saved_sql_mode       = @@sql_mode */ ;
/*!50003 SET sql_mode              = 'STRICT_TRANS_TABLES,ERROR_FOR_DIVISION_BY_ZERO,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION' */ ;
DELIMITER ;;
/*!50003 CREATE*/ /*!50017 DEFINER=`accreditation_user`@`10.100.100.149`*/ /*!50003 trigger Transports_Quota_Trigger_Delete before delete on Transports
for each row 
begin
            	declare quota_on_pass int;
            	declare initiator int;
							
							set initiator = (select Requests.InitiatorId from Requests where old.RequestId = Requests.Id limit 1);
							
            	set quota_on_pass = (select Quotas.Id from Quotas 
																		where old.TypePassId = Quotas.TypePassId and 
																		Quotas.UsedCountTransports > 0 and 
																		Quotas.InitiatorId = initiator limit 1);
            	
							if quota_on_pass is not null and initiator is not null
							then update Quotas set Quotas.UsedCountTransports = Quotas.UsedCountTransports - 1 where Quotas.Id = quota_on_pass;
							
							end if;
end */;;
DELIMITER ;
/*!50003 SET sql_mode              = @saved_sql_mode */ ;
/*!50003 SET character_set_client  = @saved_cs_client */ ;
/*!50003 SET character_set_results = @saved_cs_results */ ;
/*!50003 SET collation_connection  = @saved_col_connection */ ;

--
-- Table structure for table `TypePasses`
--

DROP TABLE IF EXISTS `TypePasses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `TypePasses` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `Name` longtext NOT NULL,
  `Description` longtext NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `TypePasses`
--

LOCK TABLES `TypePasses` WRITE;
/*!40000 ALTER TABLE `TypePasses` DISABLE KEYS */;
INSERT INTO `TypePasses` VALUES
(1,'Везде','Ну прям аще');
/*!40000 ALTER TABLE `TypePasses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `__EFMigrationsHistory`
--

DROP TABLE IF EXISTS `__EFMigrationsHistory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `__EFMigrationsHistory` (
  `MigrationId` varchar(150) NOT NULL,
  `ProductVersion` varchar(32) NOT NULL,
  PRIMARY KEY (`MigrationId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `__EFMigrationsHistory`
--

LOCK TABLES `__EFMigrationsHistory` WRITE;
/*!40000 ALTER TABLE `__EFMigrationsHistory` DISABLE KEYS */;
INSERT INTO `__EFMigrationsHistory` VALUES
('20240508174101_AddUserAndColors','8.0.4'),
('20240509055639_AddSubject','8.0.4'),
('20240509063859_AddStatus','8.0.4'),
('20240509073606_AddRole','8.0.4'),
('20240509074837_AddTransportManufacturer','8.0.4'),
('20240509091249_AddTransportModel','8.0.4'),
('20240509134521_AddBusinessDirection','8.0.4'),
('20240510060419_ModifyColumns','8.0.4'),
('20240510061841_ModifyColumnsModel','8.0.4'),
('20240510103911_AddUserFields','8.0.4'),
('20240511085211_AddRequests','8.0.4'),
('20240511093222_ModifyRequests','8.0.4'),
('20240511121358_RequestCreatedOnToDateTime','8.0.4'),
('20240511134510_AddTransport','8.0.4'),
('20240511144045_RequestCascadeDelete','8.0.4'),
('20240512065618_RemoveColorNameLimit','8.0.4'),
('20240512084903_AddTransportField','8.0.4'),
('20240513070030_TransportAddPhotos','8.0.4'),
('20240513071216_TransportPhotosDefaultValue','8.0.4'),
('20240515151950_UserUniqueLoginIndex','9.0.10'),
('20240516115031_AddTechTicket','9.0.10'),
('20240516134608_AddComment','9.0.10'),
('20240523095706_AddIndexTransport','9.0.10'),
('20240523100339_NotNullableTicketStatus','9.0.10'),
('20240523103351_AddApproveFieldsTransport','9.0.10'),
('20240523112226_AddSecurityStatus','9.0.10'),
('20240523122540_AddAuditHistory','9.0.10'),
('20240523134429_AddIssuedStatus','9.0.10'),
('20240523150358_AddRequestTrigger','9.0.10'),
('20240523152401_TruncateTransport','9.0.10'),
('20240524074626_DropBusinessDirection','9.0.10'),
('20240524080106_AddTypePass','9.0.10'),
('20240524084853_TransportAddRecipientFields','9.0.10'),
('20240524090405_Test','9.0.10'),
('20240524091047_FixTrigger','9.0.10'),
('20240524091832_NullableIssueDateAndRecipientBirth','9.0.10'),
('20240524124829_UpdateEmployeeFields','9.0.10'),
('20240524131919_AddQuotas','9.0.10'),
('20240526064134_DropTransportField','9.0.10'),
('20240526070456_AddTransportFields','9.0.10'),
('20240526072307_AddTransportIssueFields','9.0.10'),
('20240526094142_AddQuotaFields','9.0.10'),
('20240526105459_RemoveUserEmail','9.0.10'),
('20240527013916_UpdateUserPassword','9.0.10'),
('20240527093533_AddRequestComment','9.0.10'),
('20240527185917_RemoveRequestComment','9.0.10'),
('20240528073217_RemoveTransportYear','9.0.10'),
('20240528074153_RemoveTransportApproved','9.0.10'),
('20240528074839_AddTransportApproveDefault','9.0.10'),
('20240528075935_AddSecurityRejectedStatus','9.0.10'),
('20240528104959_AddReissuedToTransport','9.0.10'),
('20240528115000_AddOnSecurityCheck','9.0.10'),
('20240529050717_AddStatusIndex','9.0.10'),
('20240529064003_Add Description To TypePass','9.0.10'),
('20240529065559_Add fields to user','9.0.10'),
('20240529083950_AddAgainRequestComment','9.0.10'),
('20240529114924_AddStatusPositive','9.0.10'),
('20240531044657_RemoveMostTransportFields','9.0.10'),
('20240531063809_RenameRole','9.0.10'),
('20240531071016_Identity','9.0.10'),
('20240531084245_RenameRoleAgain','9.0.10'),
('20240531090914_Identity Context','9.0.10'),
('20240531091515_RemovePhone','9.0.10'),
('20240531094400_Remove password','9.0.10'),
('20240603033447_ChangeTransportTrigger','9.0.10'),
('20240603091348_AddEmailLogs','9.0.10'),
('20240604073539_Add version to Request','9.0.10'),
('20240605022507_Add version to TechTicket','9.0.10'),
('20240610072828_AddDeleteTransportTrigger','9.0.10'),
('20240618045953_ApprovedOnBack','9.0.10');
/*!40000 ALTER TABLE `__EFMigrationsHistory` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-10-31 15:23:54
